/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse.specifics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.opt.graph.sparse.specifics.CSRBooleanMatrix;
import org.jgrapht.opt.graph.sparse.specifics.SparseGraphSpecifics;

public class NoIncomingNoReindexSparseDirectedSpecifics
implements SparseGraphSpecifics {
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";
    protected static final String NO_INCOMING = "this graph does not support incoming edges";
    protected int[] source;
    protected int[] target;
    protected CSRBooleanMatrix outIncidenceMatrix;

    public NoIncomingNoReindexSparseDirectedSpecifics(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges) {
        int m = numEdges;
        this.source = new int[m];
        this.target = new int[m];
        ArrayList<Pair<Integer, Integer>> outgoing = new ArrayList<Pair<Integer, Integer>>(m);
        int[] eIndex = new int[1];
        edges.get().forEach(e -> {
            this.source[eIndex[0]] = (Integer)e.getFirst();
            this.target[eIndex[0]] = (Integer)e.getSecond();
            outgoing.add(Pair.of((Object)((Integer)e.getFirst()), (Object)eIndex[0]));
            eIndex[0] = eIndex[0] + 1;
        });
        this.outIncidenceMatrix = new CSRBooleanMatrix(numVertices, m, outgoing);
    }

    @Override
    public long edgesCount() {
        return this.outIncidenceMatrix.columns();
    }

    @Override
    public long degreeOf(Integer vertex) {
        throw new UnsupportedOperationException(NO_INCOMING);
    }

    @Override
    public Set<Integer> edgesOf(Integer vertex) {
        throw new UnsupportedOperationException(NO_INCOMING);
    }

    @Override
    public long inDegreeOf(Integer vertex) {
        throw new UnsupportedOperationException(NO_INCOMING);
    }

    @Override
    public Set<Integer> incomingEdgesOf(Integer vertex) {
        throw new UnsupportedOperationException(NO_INCOMING);
    }

    @Override
    public long outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.outIncidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.outIncidenceMatrix.nonZerosSet(vertex);
    }

    @Override
    public long verticesCount() {
        return this.outIncidenceMatrix.rows();
    }

    @Override
    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return this.source[e];
    }

    @Override
    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        return this.target[e];
    }

    @Override
    public GraphType getType() {
        return new DefaultGraphType.Builder().directed().weighted(false).modifiable(false).allowMultipleEdges(true).allowSelfLoops(true).build();
    }

    @Override
    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        Iterator<Integer> it = this.outIncidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            if (!this.getEdgeTarget(eId).equals(targetVertex)) continue;
            return eId;
        }
        return null;
    }

    @Override
    public Set<Integer> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        Iterator<Integer> it = this.outIncidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            if (!this.getEdgeTarget(eId).equals(targetVertex)) continue;
            result.add(eId);
        }
        return result;
    }
}

