/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse.specifics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.opt.graph.sparse.specifics.CSRBooleanMatrix;
import org.jgrapht.opt.graph.sparse.specifics.SparseGraphSpecifics;

public class IncidenceMatrixSparseUndirectedSpecifics
implements SparseGraphSpecifics {
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";
    protected CSRBooleanMatrix incidenceMatrix;
    protected int[] source;
    protected int[] target;

    public IncidenceMatrixSparseUndirectedSpecifics(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges) {
        int m = numEdges;
        this.source = new int[m];
        this.target = new int[m];
        ArrayList<Pair<Integer, Integer>> nonZeros = new ArrayList<Pair<Integer, Integer>>(m);
        int[] eIndex = new int[1];
        edges.get().forEach(e -> {
            nonZeros.add(Pair.of((Object)((Integer)e.getFirst()), (Object)eIndex[0]));
            nonZeros.add(Pair.of((Object)((Integer)e.getSecond()), (Object)eIndex[0]));
            this.source[eIndex[0]] = (Integer)e.getFirst();
            this.target[eIndex[0]] = (Integer)e.getSecond();
            eIndex[0] = eIndex[0] + 1;
        });
        this.incidenceMatrix = new CSRBooleanMatrix(numVertices, m, nonZeros);
    }

    @Override
    public long edgesCount() {
        return this.incidenceMatrix.columns();
    }

    @Override
    public long verticesCount() {
        return this.incidenceMatrix.rows();
    }

    @Override
    public long degreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> edgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    @Override
    public long inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> incomingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    @Override
    public long outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    @Override
    public GraphType getType() {
        return new DefaultGraphType.Builder().undirected().weighted(false).modifiable(false).allowMultipleEdges(true).allowSelfLoops(true).build();
    }

    @Override
    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return this.source[e];
    }

    @Override
    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        return this.target[e];
    }

    @Override
    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        Iterator<Integer> it = this.incidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            int v = this.getEdgeSource(eId);
            int u = this.getEdgeTarget(eId);
            if ((v != sourceVertex || u != targetVertex) && (v != targetVertex || u != sourceVertex)) continue;
            return eId;
        }
        return null;
    }

    @Override
    public Set<Integer> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        Iterator<Integer> it = this.incidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            int v = this.getEdgeSource(eId);
            int u = this.getEdgeTarget(eId);
            if ((v != sourceVertex || u != targetVertex) && (v != targetVertex || u != sourceVertex)) continue;
            result.add(eId);
        }
        return result;
    }
}

