/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.alg.util.Pair;

class CSRBooleanMatrix
implements Serializable {
    private static final long serialVersionUID = -8639339411487665967L;
    private static final Comparator<Pair<Integer, Integer>> INTEGER_PAIR_LEX_COMPARATOR = (o1, o2) -> {
        if ((Integer)o1.getFirst() < (Integer)o2.getFirst()) {
            return -1;
        }
        if ((Integer)o1.getFirst() > (Integer)o2.getFirst()) {
            return 1;
        }
        if ((Integer)o1.getSecond() < (Integer)o2.getSecond()) {
            return -1;
        }
        if ((Integer)o1.getSecond() > (Integer)o2.getSecond()) {
            return 1;
        }
        return 0;
    };
    private int columns;
    private int[] rowOffsets;
    private int[] columnIndices;

    public CSRBooleanMatrix(int rows, int columns, List<Pair<Integer, Integer>> entries) {
        if (rows < 1) {
            throw new IllegalArgumentException("Rows must be positive");
        }
        if (columns < 1) {
            throw new IllegalArgumentException("Columns must be positive");
        }
        if (entries == null) {
            throw new IllegalArgumentException("Entries cannot be null");
        }
        this.columns = columns;
        this.rowOffsets = new int[rows + 1];
        this.columnIndices = new int[entries.size()];
        Iterator it = entries.stream().sorted(INTEGER_PAIR_LEX_COMPARATOR).iterator();
        int cIndex = 0;
        while (it.hasNext()) {
            Pair e = (Pair)it.next();
            int column = (Integer)e.getSecond();
            if (column < 0 || column >= columns) {
                throw new IllegalArgumentException("Entry at invalid column: " + column);
            }
            this.columnIndices[cIndex++] = column;
            int row = (Integer)e.getFirst();
            int n = row + 1;
            this.rowOffsets[n] = this.rowOffsets[n] + 1;
        }
        Arrays.parallelPrefix(this.rowOffsets, (x, y) -> x + y);
    }

    public int columns() {
        return this.columns;
    }

    public int rows() {
        return this.rowOffsets.length - 1;
    }

    public int nonZeros(int row) {
        assert (row >= 0 && row < this.rowOffsets.length);
        return this.rowOffsets[row + 1] - this.rowOffsets[row];
    }

    public Iterator<Integer> nonZerosPositionIterator(int row) {
        assert (row >= 0 && row < this.rowOffsets.length);
        return new NonZerosIterator(row);
    }

    public Set<Integer> nonZerosSet(int row) {
        assert (row >= 0 && row < this.rowOffsets.length);
        LinkedHashSet<Integer> nonZeros = new LinkedHashSet<Integer>();
        new NonZerosIterator(row).forEachRemaining(nonZeros::add);
        return nonZeros;
    }

    private class NonZerosIterator
    implements Iterator<Integer> {
        private int curPos;
        private int toPos;

        public NonZerosIterator(int row) {
            this.curPos = CSRBooleanMatrix.this.rowOffsets[row];
            this.toPos = CSRBooleanMatrix.this.rowOffsets[row + 1];
        }

        @Override
        public boolean hasNext() {
            return this.curPos < this.toPos;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return CSRBooleanMatrix.this.columnIndices[this.curPos++];
        }
    }
}

