/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.opt.graph.sparse.CSRBooleanMatrix;
import org.jgrapht.opt.graph.sparse.CompleteIntegerSet;

public class SparseIntUndirectedGraph
extends AbstractGraph<Integer, Integer> {
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";
    protected CSRBooleanMatrix incidenceMatrix;
    protected CSRBooleanMatrix incidenceMatrixT;

    public SparseIntUndirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        int m = edges.size();
        ArrayList<Pair<Integer, Integer>> nonZeros = new ArrayList<Pair<Integer, Integer>>(m);
        ArrayList<Pair<Integer, Integer>> nonZerosTranspose = new ArrayList<Pair<Integer, Integer>>(m);
        int eIndex = 0;
        for (Pair<Integer, Integer> e : edges) {
            nonZeros.add((Pair<Integer, Integer>)Pair.of((Object)((Integer)e.getFirst()), (Object)eIndex));
            nonZerosTranspose.add((Pair<Integer, Integer>)Pair.of((Object)eIndex, (Object)((Integer)e.getFirst())));
            nonZeros.add((Pair<Integer, Integer>)Pair.of((Object)((Integer)e.getSecond()), (Object)eIndex));
            nonZerosTranspose.add((Pair<Integer, Integer>)Pair.of((Object)eIndex, (Object)((Integer)e.getSecond())));
            ++eIndex;
        }
        this.incidenceMatrix = new CSRBooleanMatrix(numVertices, m, nonZeros);
        this.incidenceMatrixT = new CSRBooleanMatrix(edges.size(), numVertices, nonZerosTranspose);
    }

    public Supplier<Integer> getVertexSupplier() {
        return null;
    }

    public Supplier<Integer> getEdgeSupplier() {
        return null;
    }

    public Integer addEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addEdge(Integer sourceVertex, Integer targetVertex, Integer e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Integer addVertex() {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean containsEdge(Integer e) {
        return e >= 0 && e < this.incidenceMatrix.columns();
    }

    public boolean containsVertex(Integer v) {
        return v >= 0 && v < this.incidenceMatrix.rows();
    }

    public Set<Integer> edgeSet() {
        return new CompleteIntegerSet(this.incidenceMatrix.columns());
    }

    public int degreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> edgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    public int inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> incomingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    public int outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.incidenceMatrix.nonZerosSet(vertex);
    }

    public Integer removeEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeEdge(Integer e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Set<Integer> vertexSet() {
        return new CompleteIntegerSet(this.incidenceMatrix.rows());
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().undirected().weighted(false).modifiable(false).allowMultipleEdges(true).allowSelfLoops(true).build();
    }

    public double getEdgeWeight(Integer e) {
        return 1.0;
    }

    public void setEdgeWeight(Integer e, double weight) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return this.incidenceMatrixT.nonZerosPositionIterator(e).next();
    }

    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        Iterator<Integer> it = this.incidenceMatrixT.nonZerosPositionIterator(e);
        it.next();
        return it.next();
    }

    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        Iterator<Integer> it = this.incidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            int v = this.getEdgeSource(eId);
            int u = this.getEdgeTarget(eId);
            if ((v != sourceVertex || u != targetVertex) && (v != targetVertex || u != sourceVertex)) continue;
            return eId;
        }
        return null;
    }

    public Set<Integer> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.incidenceMatrix.rows()) {
            return null;
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        Iterator<Integer> it = this.incidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            int v = this.getEdgeSource(eId);
            int u = this.getEdgeTarget(eId);
            if ((v != sourceVertex || u != targetVertex) && (v != targetVertex || u != sourceVertex)) continue;
            result.add(eId);
        }
        return result;
    }

    protected boolean assertVertexExist(Integer v) {
        if (v >= 0 && v < this.incidenceMatrix.rows()) {
            return true;
        }
        throw new IllegalArgumentException("no such vertex in graph: " + v.toString());
    }

    protected boolean assertEdgeExist(Integer e) {
        if (e >= 0 && e < this.incidenceMatrix.columns()) {
            return true;
        }
        throw new IllegalArgumentException("no such edge in graph: " + e.toString());
    }
}

