/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.Triple;
import org.jgrapht.opt.graph.sparse.SparseIntDirectedGraph;

public class SparseIntDirectedWeightedGraph
extends SparseIntDirectedGraph
implements Serializable {
    private static final long serialVersionUID = -7601401110000642281L;
    protected double[] weights;

    public SparseIntDirectedWeightedGraph(int numVertices, List<Triple<Integer, Integer, Double>> edges) {
        super(numVertices, edges.stream().map(e -> Pair.of((Object)((Integer)e.getFirst()), (Object)((Integer)e.getSecond()))).collect(Collectors.toList()));
        this.weights = new double[edges.size()];
        int eIndex = 0;
        for (Triple<Integer, Integer, Double> e2 : edges) {
            double edgeWeight = e2.getThird() != null ? (Double)e2.getThird() : 1.0;
            this.weights[eIndex++] = edgeWeight;
        }
    }

    @Override
    public GraphType getType() {
        return super.getType().asWeighted();
    }

    @Override
    public double getEdgeWeight(Integer e) {
        this.assertEdgeExist(e);
        return this.weights[e];
    }

    @Override
    public void setEdgeWeight(Integer e, double weight) {
        this.assertEdgeExist(e);
        this.weights[e.intValue()] = weight;
    }
}

