/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.opt.graph.sparse.CSRBooleanMatrix;
import org.jgrapht.opt.graph.sparse.CompleteIntegerSet;
import org.jgrapht.util.UnmodifiableUnionSet;

public class SparseIntDirectedGraph
extends AbstractGraph<Integer, Integer> {
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";
    protected int[] source;
    protected int[] target;
    protected CSRBooleanMatrix outIncidenceMatrix;
    protected CSRBooleanMatrix inIncidenceMatrix;

    public SparseIntDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        int m = edges.size();
        this.source = new int[m];
        this.target = new int[m];
        ArrayList<Pair<Integer, Integer>> outgoing = new ArrayList<Pair<Integer, Integer>>(m);
        ArrayList<Pair<Integer, Integer>> incoming = new ArrayList<Pair<Integer, Integer>>(m);
        int eIndex = 0;
        for (Pair<Integer, Integer> e : edges) {
            this.source[eIndex] = (Integer)e.getFirst();
            this.target[eIndex] = (Integer)e.getSecond();
            outgoing.add((Pair<Integer, Integer>)Pair.of((Object)((Integer)e.getFirst()), (Object)eIndex));
            incoming.add((Pair<Integer, Integer>)Pair.of((Object)((Integer)e.getSecond()), (Object)eIndex));
            ++eIndex;
        }
        this.outIncidenceMatrix = new CSRBooleanMatrix(numVertices, m, outgoing);
        this.inIncidenceMatrix = new CSRBooleanMatrix(numVertices, m, incoming);
    }

    public Supplier<Integer> getVertexSupplier() {
        return null;
    }

    public Supplier<Integer> getEdgeSupplier() {
        return null;
    }

    public Integer addEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addEdge(Integer sourceVertex, Integer targetVertex, Integer e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Integer addVertex() {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean containsEdge(Integer e) {
        return e >= 0 && e < this.outIncidenceMatrix.columns();
    }

    public boolean containsVertex(Integer v) {
        return v >= 0 && v < this.outIncidenceMatrix.rows();
    }

    public Set<Integer> edgeSet() {
        return new CompleteIntegerSet(this.outIncidenceMatrix.columns());
    }

    public int degreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.outIncidenceMatrix.nonZeros(vertex) + this.inIncidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> edgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return new UnmodifiableUnionSet(this.outIncidenceMatrix.nonZerosSet(vertex), this.inIncidenceMatrix.nonZerosSet(vertex));
    }

    public int inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.inIncidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> incomingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.inIncidenceMatrix.nonZerosSet(vertex);
    }

    public int outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.outIncidenceMatrix.nonZeros(vertex);
    }

    public Set<Integer> outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return this.outIncidenceMatrix.nonZerosSet(vertex);
    }

    public Integer removeEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeEdge(Integer e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Set<Integer> vertexSet() {
        return new CompleteIntegerSet(this.outIncidenceMatrix.rows());
    }

    public Integer getEdgeSource(Integer e) {
        this.assertEdgeExist(e);
        return this.source[e];
    }

    public Integer getEdgeTarget(Integer e) {
        this.assertEdgeExist(e);
        return this.target[e];
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().directed().weighted(false).modifiable(false).allowMultipleEdges(true).allowSelfLoops(true).build();
    }

    public double getEdgeWeight(Integer e) {
        return 1.0;
    }

    public void setEdgeWeight(Integer e, double weight) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Integer getEdge(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        Iterator<Integer> it = this.outIncidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            if (this.getEdgeTarget(eId) != targetVertex) continue;
            return eId;
        }
        return null;
    }

    public Set<Integer> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex < 0 || sourceVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        if (targetVertex < 0 || targetVertex >= this.outIncidenceMatrix.rows()) {
            return null;
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        Iterator<Integer> it = this.outIncidenceMatrix.nonZerosPositionIterator(sourceVertex);
        while (it.hasNext()) {
            int eId = it.next();
            if (this.getEdgeTarget(eId) != targetVertex) continue;
            result.add(eId);
        }
        return result;
    }

    protected boolean assertVertexExist(Integer v) {
        if (v >= 0 && v < this.outIncidenceMatrix.rows()) {
            return true;
        }
        throw new IllegalArgumentException("no such vertex in graph: " + v.toString());
    }

    protected boolean assertEdgeExist(Integer e) {
        if (e >= 0 && e < this.outIncidenceMatrix.columns()) {
            return true;
        }
        throw new IllegalArgumentException("no such edge in graph: " + e.toString());
    }
}

