/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.Graphs;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseNetworkAdapter;
import org.jgrapht.util.TypeUtil;

public class MutableNetworkAdapter<V, E>
extends BaseNetworkAdapter<V, E, MutableNetwork<V, E>>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7450826703235510224L;
    protected static final String GRAPH_IS_UNWEIGHTED = "Graph is unweighted";

    public MutableNetworkAdapter(MutableNetwork<V, E> network) {
        this(network, (Supplier<V>)null, (Supplier<E>)null);
    }

    public MutableNetworkAdapter(MutableNetwork<V, E> network, Supplier<V> vertexSupplier, Supplier<E> edgeSupplier) {
        super(network, vertexSupplier, edgeSupplier);
    }

    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!((MutableNetwork)this.network).allowsParallelEdges() && this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!((MutableNetwork)this.network).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        if (this.edgeSupplier == null) {
            throw new UnsupportedOperationException("The graph contains no edge supplier");
        }
        Object e = this.edgeSupplier.get();
        if (((MutableNetwork)this.network).addEdge(sourceVertex, targetVertex, e)) {
            return (E)e;
        }
        return null;
    }

    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!((MutableNetwork)this.network).allowsParallelEdges() && this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!((MutableNetwork)this.network).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        return ((MutableNetwork)this.network).addEdge(sourceVertex, targetVertex, e);
    }

    public V addVertex() {
        if (this.vertexSupplier == null) {
            throw new UnsupportedOperationException("The graph contains no vertex supplier");
        }
        Object v = this.vertexSupplier.get();
        if (((MutableNetwork)this.network).addNode(v)) {
            return (V)v;
        }
        return null;
    }

    public boolean addVertex(V v) {
        return ((MutableNetwork)this.network).addNode(v);
    }

    public E removeEdge(V sourceVertex, V targetVertex) {
        Object e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            ((MutableNetwork)this.network).removeEdge(e);
        }
        return e;
    }

    public boolean removeEdge(E e) {
        return ((MutableNetwork)this.network).removeEdge(e);
    }

    public boolean removeVertex(V v) {
        return ((MutableNetwork)this.network).removeNode(v);
    }

    public void setEdgeWeight(E e, double weight) {
        throw new UnsupportedOperationException(GRAPH_IS_UNWEIGHTED);
    }

    public Object clone() {
        try {
            MutableNetworkAdapter newGraph = (MutableNetworkAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.network = Graphs.copyOf((Network)this.network);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (Object e : this.edgeSet()) {
            oos.writeObject(this.getEdgeSource(e));
            oos.writeObject(this.getEdgeTarget(e));
            oos.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed()) {
            throw new IOException("Graph type not supported");
        }
        this.network = (type.isDirected() ? NetworkBuilder.directed() : NetworkBuilder.undirected()).allowsParallelEdges(type.isAllowingMultipleEdges()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            ((MutableNetwork)this.network).addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            Object e = ois.readObject();
            ((MutableNetwork)this.network).addEdge(s, t, e);
        }
    }
}

