/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.ValueGraph;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;

public abstract class BaseValueGraphAdapter<V, W, VG extends ValueGraph<V, W>>
extends AbstractGraph<V, EndpointPair<V>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3833510139696864917L;
    protected static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    protected transient Set<V> unmodifiableVertexSet = null;
    protected transient Set<EndpointPair<V>> unmodifiableEdgeSet = null;
    protected Supplier<V> vertexSupplier;
    protected Supplier<EndpointPair<V>> edgeSupplier;
    protected ToDoubleFunction<W> valueConverter;
    protected transient VG valueGraph;

    public BaseValueGraphAdapter(VG valueGraph, ToDoubleFunction<W> valueConverter) {
        this(valueGraph, valueConverter, null, null);
    }

    public BaseValueGraphAdapter(VG valueGraph, ToDoubleFunction<W> valueConverter, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier) {
        this.vertexSupplier = vertexSupplier;
        this.edgeSupplier = edgeSupplier;
        this.valueGraph = (ValueGraph)Objects.requireNonNull(valueGraph);
        this.valueConverter = Objects.requireNonNull(valueConverter);
    }

    public Supplier<V> getVertexSupplier() {
        return this.vertexSupplier;
    }

    public void setVertexSupplier(Supplier<V> vertexSupplier) {
        this.vertexSupplier = vertexSupplier;
    }

    public Supplier<EndpointPair<V>> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public void setEdgeSupplier(Supplier<EndpointPair<V>> edgeSupplier) {
        this.edgeSupplier = edgeSupplier;
    }

    public EndpointPair<V> getEdge(V sourceVertex, V targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        if (!this.valueGraph.hasEdgeConnecting(sourceVertex, targetVertex)) {
            return null;
        }
        return this.createEdge(sourceVertex, targetVertex);
    }

    @Deprecated
    public EdgeFactory<V, EndpointPair<V>> getEdgeFactory() {
        return null;
    }

    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.valueGraph.nodes());
        }
        return this.unmodifiableVertexSet;
    }

    public V getEdgeSource(EndpointPair<V> e) {
        return (V)e.nodeU();
    }

    public V getEdgeTarget(EndpointPair<V> e) {
        return (V)e.nodeV();
    }

    public GraphType getType() {
        return (this.valueGraph.isDirected() ? new DefaultGraphType.Builder().directed() : new DefaultGraphType.Builder().undirected()).weighted(true).allowMultipleEdges(false).allowSelfLoops(this.valueGraph.allowsSelfLoops()).build();
    }

    public boolean containsEdge(EndpointPair<V> e) {
        return this.valueGraph.edges().contains(e);
    }

    public boolean containsVertex(V v) {
        return this.valueGraph.nodes().contains(v);
    }

    public Set<EndpointPair<V>> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.valueGraph.edges());
        }
        return this.unmodifiableEdgeSet;
    }

    public int degreeOf(V vertex) {
        return this.valueGraph.degree(vertex);
    }

    public Set<EndpointPair<V>> edgesOf(V vertex) {
        return this.valueGraph.incidentEdges(vertex);
    }

    public int inDegreeOf(V vertex) {
        return this.valueGraph.inDegree(vertex);
    }

    public Set<EndpointPair<V>> incomingEdgesOf(V vertex) {
        return this.valueGraph.predecessors(vertex).stream().map(other -> this.createEdge(other, vertex)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public int outDegreeOf(V vertex) {
        return this.valueGraph.outDegree(vertex);
    }

    public Set<EndpointPair<V>> outgoingEdgesOf(V vertex) {
        return this.valueGraph.successors(vertex).stream().map(other -> this.createEdge(vertex, other)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public double getEdgeWeight(EndpointPair<V> e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.valueGraph.hasEdgeConnecting(e.nodeU(), e.nodeV())) {
            throw new IllegalArgumentException("no such edge in graph: " + e.toString());
        }
        return this.valueGraph.edgeValue(e.nodeU(), e.nodeV()).map(this.valueConverter::applyAsDouble).orElse(1.0);
    }

    public Set<EndpointPair<V>> getAllEdges(V sourceVertex, V targetVertex) {
        if (sourceVertex == null || targetVertex == null || !this.valueGraph.nodes().contains(sourceVertex) || !this.valueGraph.nodes().contains(targetVertex)) {
            return null;
        }
        if (!this.valueGraph.hasEdgeConnecting(sourceVertex, targetVertex)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.createEdge(sourceVertex, targetVertex));
    }

    final EndpointPair<V> createEdge(V s, V t) {
        return this.valueGraph.isDirected() ? EndpointPair.ordered(s, t) : EndpointPair.unordered(s, t);
    }
}

