/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.Network;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;

public abstract class BaseNetworkAdapter<V, E, N extends Network<V, E>>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6233085794632237761L;
    protected static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    protected transient Set<V> unmodifiableVertexSet = null;
    protected transient Set<E> unmodifiableEdgeSet = null;
    protected Supplier<V> vertexSupplier;
    protected Supplier<E> edgeSupplier;
    protected transient N network;

    public BaseNetworkAdapter(N network) {
        this(network, null, null);
    }

    public BaseNetworkAdapter(N network, Supplier<V> vertexSupplier, Supplier<E> edgeSupplier) {
        this.vertexSupplier = vertexSupplier;
        this.edgeSupplier = edgeSupplier;
        this.network = (Network)Objects.requireNonNull(network);
    }

    public Supplier<V> getVertexSupplier() {
        return this.vertexSupplier;
    }

    public void setVertexSupplier(Supplier<V> vertexSupplier) {
        this.vertexSupplier = vertexSupplier;
    }

    public Supplier<E> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public void setEdgeSupplier(Supplier<E> edgeSupplier) {
        this.edgeSupplier = edgeSupplier;
    }

    public E getEdge(V sourceVertex, V targetVertex) {
        return this.network.edgesConnecting(sourceVertex, targetVertex).stream().findFirst().orElse(null);
    }

    @Deprecated
    public EdgeFactory<V, E> getEdgeFactory() {
        return null;
    }

    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.network.nodes());
        }
        return this.unmodifiableVertexSet;
    }

    public V getEdgeSource(E e) {
        return (V)this.network.incidentNodes(e).nodeU();
    }

    public V getEdgeTarget(E e) {
        return (V)this.network.incidentNodes(e).nodeV();
    }

    public GraphType getType() {
        return (this.network.isDirected() ? new DefaultGraphType.Builder().directed() : new DefaultGraphType.Builder().undirected()).weighted(false).allowMultipleEdges(this.network.allowsParallelEdges()).allowSelfLoops(this.network.allowsSelfLoops()).build();
    }

    public boolean containsEdge(E e) {
        return this.network.edges().contains(e);
    }

    public boolean containsVertex(V v) {
        return this.network.nodes().contains(v);
    }

    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.network.edges());
        }
        return this.unmodifiableEdgeSet;
    }

    public int degreeOf(V vertex) {
        return this.network.degree(vertex);
    }

    public Set<E> edgesOf(V vertex) {
        return this.network.incidentEdges(vertex);
    }

    public int inDegreeOf(V vertex) {
        return this.network.inDegree(vertex);
    }

    public Set<E> incomingEdgesOf(V vertex) {
        return this.network.inEdges(vertex);
    }

    public int outDegreeOf(V vertex) {
        return this.network.outDegree(vertex);
    }

    public Set<E> outgoingEdgesOf(V vertex) {
        return this.network.outEdges(vertex);
    }

    public double getEdgeWeight(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.network.edges().contains(e)) {
            throw new IllegalArgumentException("no such edge in graph: " + e.toString());
        }
        return 1.0;
    }

    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        return this.network.edgesConnecting(sourceVertex, targetVertex);
    }
}

