/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.ClassBasedVertexFactory;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public final class CompleteGraphDemo {
    static Graph<Object, DefaultEdge> completeGraph;
    static int size;

    public static void main(String[] args) {
        completeGraph = new SimpleGraph(DefaultEdge.class);
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(size);
        ClassBasedVertexFactory vFactory = new ClassBasedVertexFactory(Object.class);
        completeGenerator.generateGraph(completeGraph, (VertexFactory)vFactory, null);
        HashSet vertices = new HashSet();
        vertices.addAll(completeGraph.vertexSet());
        Integer counter = 0;
        for (Object vertex : vertices) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            CompleteGraphDemo.replaceVertex(vertex, n);
        }
        DepthFirstIterator iter = new DepthFirstIterator(completeGraph);
        while (iter.hasNext()) {
            Object vertex;
            vertex = iter.next();
            System.out.println("Vertex " + vertex.toString() + " is connected to: " + completeGraph.edgesOf(vertex).toString());
        }
    }

    public static boolean replaceVertex(Object oldVertex, Object newVertex) {
        if (oldVertex == null || newVertex == null) {
            return false;
        }
        Set relatedEdges = completeGraph.edgesOf(oldVertex);
        completeGraph.addVertex(newVertex);
        for (DefaultEdge e : relatedEdges) {
            Object sourceVertex = completeGraph.getEdgeSource((Object)e);
            Object targetVertex = completeGraph.getEdgeTarget((Object)e);
            if (sourceVertex.equals(oldVertex) && targetVertex.equals(oldVertex)) {
                completeGraph.addEdge(newVertex, newVertex);
                continue;
            }
            if (sourceVertex.equals(oldVertex)) {
                completeGraph.addEdge(newVertex, targetVertex);
                continue;
            }
            completeGraph.addEdge(sourceVertex, newVertex);
        }
        completeGraph.removeVertex(oldVertex);
        return true;
    }

    static {
        size = 10;
    }
}

