/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.util.WeightCombiner;

public class AsGraphUnion<V, E>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = -3848082143382987713L;
    private static final String READ_ONLY = "union of graphs is read-only";
    private final Graph<V, E> g1;
    private final GraphType type1;
    private final Graph<V, E> g2;
    private final GraphType type2;
    private final GraphType type;
    private final WeightCombiner operator;

    public AsGraphUnion(Graph<V, E> g1, Graph<V, E> g2, WeightCombiner operator) {
        this.g1 = GraphTests.requireDirectedOrUndirected(g1);
        this.type1 = g1.getType();
        this.g2 = GraphTests.requireDirectedOrUndirected(g2);
        this.type2 = g2.getType();
        if (g1 == g2) {
            throw new IllegalArgumentException("g1 is equal to g2");
        }
        this.operator = Objects.requireNonNull(operator, "Weight combiner cannot be null");
        DefaultGraphType.Builder builder = new DefaultGraphType.Builder();
        builder = this.type1.isDirected() && this.type2.isDirected() ? builder.directed() : (this.type1.isUndirected() && this.type2.isUndirected() ? builder.undirected() : builder.mixed());
        this.type = builder.allowSelfLoops(this.type1.isAllowingSelfLoops() || this.type2.isAllowingSelfLoops()).allowMultipleEdges(true).weighted(true).modifiable(false).build();
    }

    public AsGraphUnion(Graph<V, E> g1, Graph<V, E> g2) {
        this(g1, g2, WeightCombiner.SUM);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        LinkedHashSet<E> res = new LinkedHashSet<E>();
        if (this.g1.containsVertex(sourceVertex) && this.g1.containsVertex(targetVertex)) {
            res.addAll(this.g1.getAllEdges(sourceVertex, targetVertex));
        }
        if (this.g2.containsVertex(sourceVertex) && this.g2.containsVertex(targetVertex)) {
            res.addAll(this.g2.getAllEdges(sourceVertex, targetVertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        E res = null;
        if (this.g1.containsVertex(sourceVertex) && this.g1.containsVertex(targetVertex)) {
            res = this.g1.getEdge(sourceVertex, targetVertex);
        }
        if (res == null && this.g2.containsVertex(sourceVertex) && this.g2.containsVertex(targetVertex)) {
            res = this.g2.getEdge(sourceVertex, targetVertex);
        }
        return res;
    }

    @Override
    @Deprecated
    public EdgeFactory<V, E> getEdgeFactory() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Supplier<V> getVertexSupplier() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Supplier<E> getEdgeSupplier() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public V addVertex() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean containsEdge(E e) {
        return this.g1.containsEdge(e) || this.g2.containsEdge(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.g1.containsVertex(v) || this.g2.containsVertex(v);
    }

    @Override
    public Set<E> edgeSet() {
        LinkedHashSet<E> res = new LinkedHashSet<E>();
        res.addAll(this.g1.edgeSet());
        res.addAll(this.g2.edgeSet());
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        LinkedHashSet<E> res = new LinkedHashSet<E>();
        if (this.g1.containsVertex(vertex)) {
            res.addAll(this.g1.edgesOf(vertex));
        }
        if (this.g2.containsVertex(vertex)) {
            res.addAll(this.g2.edgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        LinkedHashSet<E> res = new LinkedHashSet<E>();
        if (this.g1.containsVertex(vertex)) {
            res.addAll(this.g1.incomingEdgesOf(vertex));
        }
        if (this.g2.containsVertex(vertex)) {
            res.addAll(this.g2.incomingEdgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        LinkedHashSet<E> res = new LinkedHashSet<E>();
        if (this.g1.containsVertex(vertex)) {
            res.addAll(this.g1.outgoingEdgesOf(vertex));
        }
        if (this.g2.containsVertex(vertex)) {
            res.addAll(this.g2.outgoingEdgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public int degreeOf(V vertex) {
        if (this.type.isMixed()) {
            int d = 0;
            if (this.g1.containsVertex(vertex)) {
                d += this.g1.degreeOf(vertex);
            }
            if (this.g2.containsVertex(vertex)) {
                d += this.g2.degreeOf(vertex);
            }
            return d;
        }
        if (this.type.isUndirected()) {
            int degree = 0;
            for (E e : this.edgesOf(vertex)) {
                ++degree;
                if (!this.getEdgeSource(e).equals(this.getEdgeTarget(e))) continue;
                ++degree;
            }
            return degree;
        }
        return this.incomingEdgesOf(vertex).size() + this.outgoingEdgesOf(vertex).size();
    }

    @Override
    public int inDegreeOf(V vertex) {
        if (this.type.isMixed()) {
            int d = 0;
            if (this.g1.containsVertex(vertex)) {
                d += this.g1.inDegreeOf(vertex);
            }
            if (this.g2.containsVertex(vertex)) {
                d += this.g2.inDegreeOf(vertex);
            }
            return d;
        }
        if (this.type.isUndirected()) {
            return this.degreeOf(vertex);
        }
        return this.incomingEdgesOf(vertex).size();
    }

    @Override
    public int outDegreeOf(V vertex) {
        if (this.type.isMixed()) {
            int d = 0;
            if (this.g1.containsVertex(vertex)) {
                d += this.g1.outDegreeOf(vertex);
            }
            if (this.g2.containsVertex(vertex)) {
                d += this.g2.outDegreeOf(vertex);
            }
            return d;
        }
        if (this.type.isUndirected()) {
            return this.degreeOf(vertex);
        }
        return this.outgoingEdgesOf(vertex).size();
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Set<V> vertexSet() {
        HashSet<V> res = new HashSet<V>();
        res.addAll(this.g1.vertexSet());
        res.addAll(this.g2.vertexSet());
        return Collections.unmodifiableSet(res);
    }

    @Override
    public V getEdgeSource(E e) {
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeSource(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeSource(e);
        }
        return null;
    }

    @Override
    public V getEdgeTarget(E e) {
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeTarget(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeTarget(e);
        }
        return null;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (this.g1.containsEdge(e) && this.g2.containsEdge(e)) {
            return this.operator.combine(this.g1.getEdgeWeight(e), this.g2.getEdgeWeight(e));
        }
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeWeight(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeWeight(e);
        }
        throw new IllegalArgumentException("no such edge in the union");
    }

    @Override
    public GraphType getType() {
        return this.type;
    }

    @Override
    public void setEdgeWeight(E e, double weight) {
        throw new UnsupportedOperationException(READ_ONLY);
    }
}

