/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jfxtras.icalendarfx.utilities.Pair;

public final class ICalendarUtilities {
    public static final String PROPERTY_VALUE_KEY = ":";

    private ICalendarUtilities() {
    }

    public static List<Pair<String, String>> parseInlineElementsToListPair(String propertyLine) {
        int firstCharacter;
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        int parameterStart = 0;
        for (parameterStart = 0; parameterStart < propertyLine.length() && propertyLine.charAt(parameterStart) != ';' && propertyLine.charAt(parameterStart) != ':'; ++parameterStart) {
            if (propertyLine.charAt(parameterStart) != '=') continue;
            parameterStart = -1;
            break;
        }
        if (parameterStart == propertyLine.length()) {
            parameterStart = 0;
            firstCharacter = 58;
        } else {
            if (parameterStart == propertyLine.length() - 1) {
                parameters.add(new Pair<String, Object>(PROPERTY_VALUE_KEY, null));
                return parameters;
            }
            if (parameterStart < 0) {
                firstCharacter = 59;
                parameterStart = 0;
            } else if (parameterStart == 0) {
                firstCharacter = propertyLine.charAt(parameterStart);
                parameterStart = 1;
            } else {
                firstCharacter = propertyLine.charAt(parameterStart);
                ++parameterStart;
            }
        }
        int parameterEnd = parameterStart;
        boolean quoteOn = false;
        while (parameterEnd < propertyLine.length()) {
            String value;
            String name;
            if (firstCharacter == 58) {
                parameterEnd = propertyLine.length();
                name = PROPERTY_VALUE_KEY;
                value = propertyLine.substring(parameterStart, parameterEnd);
            } else if (firstCharacter == 59) {
                int equalsPosition = propertyLine.indexOf(61, parameterStart);
                int nextSemicolonPosition = propertyLine.indexOf(59, parameterStart);
                if (nextSemicolonPosition > 0 && nextSemicolonPosition < equalsPosition) {
                    value = null;
                    name = propertyLine.substring(parameterStart, nextSemicolonPosition).toUpperCase();
                    parameterEnd = nextSemicolonPosition;
                } else {
                    name = propertyLine.substring(parameterStart, equalsPosition).toUpperCase();
                    for (parameterEnd = equalsPosition + 1; parameterEnd < propertyLine.length(); ++parameterEnd) {
                        if (propertyLine.charAt(parameterEnd) == '\"') {
                            boolean bl = quoteOn = !quoteOn;
                        }
                        if (!quoteOn && (propertyLine.charAt(parameterEnd) == ';' || propertyLine.charAt(parameterEnd) == ':')) break;
                    }
                    value = propertyLine.substring(equalsPosition + 1, parameterEnd);
                }
            } else {
                throw new IllegalArgumentException("Invalid property line:" + propertyLine);
            }
            parameters.add(new Pair<String, String>(name, value));
            if (parameterEnd >= propertyLine.length()) continue;
            parameterStart = parameterEnd + 1;
            firstCharacter = propertyLine.charAt(parameterStart - 1);
        }
        return parameters;
    }

    public static CharSequence foldLine(CharSequence line) {
        int maxLineLength = 75;
        if (line.length() <= 75) {
            return line;
        }
        StringBuilder builder = new StringBuilder(line.length() + 20);
        int leadingSpaceAdjustment = 0;
        String leadingSpace = "";
        int startIndex = 0;
        while (startIndex < line.length()) {
            int endIndex = Math.min(startIndex + 75 - leadingSpaceAdjustment, line.length());
            if (endIndex < line.length()) {
                if (line.charAt(endIndex - 1) == '\\') {
                    --endIndex;
                }
                builder.append(leadingSpace + line.subSequence(startIndex, endIndex) + System.lineSeparator());
            } else {
                builder.append(leadingSpace + line.subSequence(startIndex, endIndex));
            }
            startIndex = endIndex;
            leadingSpaceAdjustment = 1;
            leadingSpace = " ";
        }
        return builder;
    }

    @Deprecated
    public static int getPropertyNameIndex(String propertyLine) {
        int propertyNameEnd;
        if (propertyLine == null || propertyLine.length() == 0) {
            return 0;
        }
        for (propertyNameEnd = 0; propertyNameEnd < propertyLine.length() && propertyLine.charAt(propertyNameEnd) != ';' && propertyLine.charAt(propertyNameEnd) != ':'; ++propertyNameEnd) {
        }
        if (propertyNameEnd < propertyLine.length()) {
            return propertyNameEnd;
        }
        return -1;
    }

    static <T> Spliterator<T> takeWhile(final Spliterator<T> splitr, final Predicate<? super T> predicate) {
        return new Spliterators.AbstractSpliterator<T>(splitr.estimateSize(), 0){
            boolean stillGoing;
            {
                super(arg0, arg1);
                this.stillGoing = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.stillGoing) {
                    boolean hadNext = splitr.tryAdvance(elem -> {
                        if (predicate.test(elem)) {
                            consumer.accept(elem);
                        } else {
                            this.stillGoing = false;
                        }
                    });
                    return hadNext && this.stillGoing;
                }
                return false;
            }
        };
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamSupport.stream(ICalendarUtilities.takeWhile(stream.spliterator(), predicate), false);
    }
}

