/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.time;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.parameters.FreeBusyType;
import jfxtras.icalendarfx.properties.PropFreeBusy;
import jfxtras.icalendarfx.properties.VPropertyBase;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.icalendarfx.utilities.Pair;
import jfxtras.icalendarfx.utilities.StringConverter;

public class FreeBusyTime
extends VPropertyBase<List<Pair<ZonedDateTime, TemporalAmount>>, FreeBusyTime>
implements PropFreeBusy<List<Pair<ZonedDateTime, TemporalAmount>>> {
    public static final StringConverter<List<Pair<ZonedDateTime, TemporalAmount>>> CONVERTER = new StringConverter<List<Pair<ZonedDateTime, TemporalAmount>>>(){

        @Override
        public String toString(List<Pair<ZonedDateTime, TemporalAmount>> object) {
            return object.stream().map(p -> {
                StringBuilder builder = new StringBuilder(30);
                builder.append(DateTimeUtilities.ZONED_DATE_TIME_UTC_FORMATTER.format((TemporalAccessor)p.getKey()));
                builder.append("/");
                builder.append(((TemporalAmount)p.getValue()).toString());
                return builder.toString();
            }).collect(Collectors.joining(","));
        }

        @Override
        public List<Pair<ZonedDateTime, TemporalAmount>> fromString(String string) {
            ArrayList<Pair<ZonedDateTime, TemporalAmount>> periodList = new ArrayList<Pair<ZonedDateTime, TemporalAmount>>();
            Arrays.asList(string.split(",")).forEach(pair -> {
                Duration duration;
                String[] time = pair.split("/");
                ZonedDateTime startInclusive = ZonedDateTime.parse(time[0], DateTimeUtilities.ZONED_DATE_TIME_UTC_FORMATTER);
                if (time[1].charAt(time[1].length() - 1) == 'Z') {
                    ZonedDateTime endExclusive = ZonedDateTime.parse(time[1], DateTimeUtilities.ZONED_DATE_TIME_UTC_FORMATTER);
                    duration = Duration.between(startInclusive, endExclusive);
                } else {
                    duration = Duration.parse(time[1]);
                }
                periodList.add(new Pair<ZonedDateTime, Duration>(startInclusive, duration));
            });
            return periodList;
        }
    };
    private FreeBusyType freeBusyType;

    @Override
    public FreeBusyType getFreeBusyType() {
        return this.freeBusyType;
    }

    @Override
    public void setFreeBusyType(FreeBusyType freeBusyType) {
        this.orderer.orderChild(freeBusyType);
        this.freeBusyType = freeBusyType;
    }

    public void setFreeBusyType(FreeBusyType.FreeBusyTypeEnum type) {
        this.setFreeBusyType(new FreeBusyType(type));
    }

    public FreeBusyTime withFreeBusyType(FreeBusyType freeBusyType) {
        this.setFreeBusyType(freeBusyType);
        return this;
    }

    public FreeBusyTime withFreeBusyType(FreeBusyType.FreeBusyTypeEnum type) {
        this.setFreeBusyType(type);
        return this;
    }

    public FreeBusyTime withFreeBusyType(String freeBusyType) {
        this.setFreeBusyType(FreeBusyType.parse(freeBusyType));
        return this;
    }

    public FreeBusyTime(FreeBusyTime source) {
        super(source);
    }

    public FreeBusyTime(List<Pair<ZonedDateTime, TemporalAmount>> values) {
        this.setConverter(CONVERTER);
        this.setValue(values);
    }

    public FreeBusyTime() {
        this.setConverter(CONVERTER);
    }

    public static FreeBusyTime parse(String content) {
        return FreeBusyTime.parse(new FreeBusyTime(), content);
    }
}

