/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;

public class ByYearDay
extends ByRuleIntegerAbstract<ByYearDay> {
    public ByYearDay() {
    }

    public ByYearDay(Integer ... yearDays) {
        super(yearDays);
    }

    public ByYearDay(ByYearDay source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= -366 && value <= 366 && value != 0;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        switch (chronoUnit) {
            case HOURS: 
            case MINUTES: 
            case SECONDS: {
                return inStream.filter(d -> {
                    int myDayOfYear = d.get(ChronoField.DAY_OF_YEAR);
                    Iterator iterator = ((List)this.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int dayOfYear = (Integer)iterator.next();
                        if (dayOfYear > 0) {
                            if (dayOfYear != myDayOfYear) continue;
                            return true;
                        }
                        Temporal firstDayOfNextYear = d.with(TemporalAdjusters.firstDayOfNextYear());
                        Period myNegativeDayOfYear = Period.between(LocalDate.from(firstDayOfNextYear), LocalDate.from(d));
                        if (!Period.ofDays(dayOfYear).equals(myNegativeDayOfYear)) continue;
                        return true;
                    }
                    return false;
                });
            }
            case YEARS: {
                return inStream.flatMap(d -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    Iterator iterator = ((List)this.getValue()).iterator();
                    while (iterator.hasNext()) {
                        Temporal newTemporal;
                        int dayOfYear = (Integer)iterator.next();
                        Temporal correctYearTemporal = dayOfYear > 0 ? d : d.minus(1L, ChronoUnit.YEARS);
                        int daysInYear = (int)ChronoUnit.DAYS.between(correctYearTemporal.with(TemporalAdjusters.firstDayOfYear()), correctYearTemporal.with(TemporalAdjusters.firstDayOfNextYear()));
                        int finalDayOfYear = 0;
                        if (dayOfYear > 0) {
                            if (dayOfYear <= daysInYear) {
                                finalDayOfYear = dayOfYear;
                            }
                        } else if (dayOfYear < 0) {
                            int newDayOfYear = daysInYear + dayOfYear + 1;
                            if (newDayOfYear > 0) {
                                finalDayOfYear = newDayOfYear;
                            }
                        } else {
                            throw new IllegalArgumentException(this.name().toString() + " can't have a value of zero");
                        }
                        if ((newTemporal = finalDayOfYear != 0 ? correctYearTemporal.with(ChronoField.DAY_OF_YEAR, finalDayOfYear) : null) == null) continue;
                        dates.add(newTemporal);
                    }
                    return dates.stream();
                });
            }
            case DAYS: 
            case WEEKS: 
            case MONTHS: {
                throw new IllegalArgumentException(this.name().toString() + " is not available for " + chronoUnit + " frequency.");
            }
        }
        throw new IllegalArgumentException("Not implemented: " + chronoUnit);
    }

    public static ByYearDay parse(String content) {
        return ByYearDay.parse(new ByYearDay(), content);
    }
}

