/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;

public class ByMinute
extends ByRuleIntegerAbstract<ByMinute> {
    public ByMinute() {
    }

    public ByMinute(Integer ... minutes) {
        super(minutes);
    }

    public ByMinute(ByMinute source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= 0 && value <= 59;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        if (dateTimeStart.isSupported(ChronoField.MINUTE_OF_HOUR)) {
            switch (chronoUnit) {
                case MINUTES: 
                case SECONDS: {
                    return inStream.filter(d -> {
                        int myMinuteOfHour = d.get(ChronoField.MINUTE_OF_HOUR);
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int minuteOfHour = (Integer)iterator.next();
                            if (minuteOfHour <= 0 || minuteOfHour != myMinuteOfHour) continue;
                            return true;
                        }
                        return false;
                    });
                }
                case HOURS: 
                case DAYS: 
                case WEEKS: 
                case MONTHS: 
                case YEARS: {
                    return inStream.flatMap(d -> {
                        ArrayList<Temporal> dates = new ArrayList<Temporal>();
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int minuteOfHour = (Integer)iterator.next();
                            Temporal newTemporal = d.with(ChronoField.MINUTE_OF_HOUR, minuteOfHour);
                            dates.add(newTemporal);
                        }
                        return dates.stream();
                    });
                }
            }
            throw new IllegalArgumentException("Not implemented: " + chronoUnit);
        }
        return inStream;
    }

    public static ByMinute parse(String content) {
        return ByMinute.parse(new ByMinute(), content);
    }
}

