/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRuleElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.WeekStart;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleAbstract;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class ByDay
extends ByRuleAbstract<ByDayPair, ByDay> {
    private static final int MIN_DAYS_IN_WEEK = 4;

    private DayOfWeek getWeekStart() {
        if (this.getParent() != null) {
            WeekStart weekStart = ((RecurrenceRuleValue)this.getParent()).getWeekStart();
            return weekStart == null ? WeekStart.DEFAULT_WEEK_START : (DayOfWeek)weekStart.getValue();
        }
        return WeekStart.DEFAULT_WEEK_START;
    }

    public ByDay() {
    }

    public ByDay(ByDayPair ... byDayPairs) {
        this();
        this.setValue((T[])byDayPairs);
    }

    public ByDay(ByDay source) {
        super(source);
    }

    public ByDay(DayOfWeek ... daysOfWeek) {
        this((Collection<DayOfWeek>)Arrays.asList(daysOfWeek));
    }

    public ByDay(Collection<DayOfWeek> daysOfWeek) {
        this();
        ByDayPair[] dayArray = (ByDayPair[])daysOfWeek.stream().map(d -> new ByDayPair((DayOfWeek)d, 0)).toArray(ByDayPair[]::new);
        this.setValue((T[])dayArray);
    }

    public boolean hasOrdinals() {
        return ((List)this.getValue()).stream().filter(p -> p.ordinal != 0).findAny().isPresent();
    }

    public boolean addDayOfWeek(DayOfWeek dayOfWeek) {
        boolean isPresent = ((List)this.getValue()).stream().map(a -> a.dayOfWeek).filter(d -> d == dayOfWeek).findAny().isPresent();
        if (!isPresent) {
            ((List)this.getValue()).add(new ByDayPair(dayOfWeek, 0));
            return true;
        }
        return false;
    }

    public boolean removeDayOfWeek(DayOfWeek dayOfWeek) {
        ByDayPair p = ((List)this.getValue()).stream().filter(v -> v.dayOfWeek == dayOfWeek).findAny().orElse(null);
        if (p != null) {
            ((List)this.getValue()).remove(p);
            return true;
        }
        return false;
    }

    public boolean replaceDayOfWeek(DayOfWeek originalDayOfWeek, DayOfWeek replacemenDayOfWeekt) {
        ByDayPair p = ((List)this.getValue()).stream().filter(v -> v.dayOfWeek == originalDayOfWeek).findAny().orElse(null);
        if (p != null) {
            int ordinal = p.getOrdinal();
            ((List)this.getValue()).remove(p);
            ((List)this.getValue()).add(new ByDayPair(replacemenDayOfWeekt, ordinal));
            return true;
        }
        return false;
    }

    public List<DayOfWeek> dayOfWeekWithoutOrdinalList() {
        return ((List)this.getValue()).stream().filter(d -> d.ordinal == 0).map(d -> d.dayOfWeek).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        if (this.getValue() == null) {
            return "";
        }
        String days = ((List)this.getValue()).stream().map(d -> {
            String day = d.dayOfWeek.toString().substring(0, 2);
            return d.ordinal == 0 ? day : d.ordinal + day;
        }).collect(Collectors.joining(","));
        return RRuleElement.BY_DAY + "=" + days;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        switch (chronoUnit) {
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case DAYS: {
                boolean isValid = ((List)this.getValue()).stream().allMatch(v -> v.getOrdinal() == 0);
                if (!isValid) {
                    throw new IllegalArgumentException("Numberic ordinal day values can't be set for FREQ as" + chronoUnit);
                }
                return inStream.filter(t -> {
                    DayOfWeek myDayOfWeek = DayOfWeek.from(t);
                    for (ByDayPair byDayPair : (List)this.getValue()) {
                        if (byDayPair.dayOfWeek != myDayOfWeek) continue;
                        return true;
                    }
                    return false;
                });
            }
            case WEEKS: {
                boolean isValid = ((List)this.getValue()).stream().allMatch(v -> v.getOrdinal() == 0);
                if (!isValid) {
                    throw new IllegalArgumentException("Numberic ordinal day values can't be set for FREQ as " + chronoUnit);
                }
                WeekFields weekFields = WeekFields.of(this.getWeekStart(), 4);
                TemporalField dayOfWeekField = weekFields.dayOfWeek();
                return inStream.flatMap(t -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    for (ByDayPair byDayPair : (List)this.getValue()) {
                        int defaultFirstDayOfWeekValue = DayOfWeek.MONDAY.getValue();
                        int myFirstDayOfWeekValue = weekFields.getFirstDayOfWeek().getValue();
                        int dayOfWeekAdjustment = defaultFirstDayOfWeekValue - myFirstDayOfWeekValue + DayOfWeek.values().length;
                        int dayOfWeekValue = byDayPair.dayOfWeek.getValue() + dayOfWeekAdjustment;
                        dayOfWeekValue = dayOfWeekValue > 7 ? dayOfWeekValue - 7 : dayOfWeekValue;
                        Temporal newTemporal = t.with(dayOfWeekField, dayOfWeekValue);
                        dates.add(newTemporal);
                    }
                    if (((List)this.getValue()).size() > 1) {
                        Collections.sort(dates, DateTimeUtilities.TEMPORAL_COMPARATOR);
                    }
                    return dates.stream();
                });
            }
            case MONTHS: {
                return inStream.flatMap(date -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    for (ByDayPair byDayPair : (List)this.getValue()) {
                        Month myMonth;
                        if (byDayPair.ordinal == 0) {
                            myMonth = Month.from(date);
                            for (int weekNum = 1; weekNum <= 5; ++weekNum) {
                                Temporal newTemporal = date.with(TemporalAdjusters.dayOfWeekInMonth(weekNum, byDayPair.dayOfWeek));
                                if (Month.from(newTemporal) != myMonth) continue;
                                dates.add(newTemporal);
                            }
                            continue;
                        }
                        myMonth = Month.from(date);
                        Temporal newTemporal = date.with(TemporalAdjusters.dayOfWeekInMonth(byDayPair.ordinal, byDayPair.dayOfWeek));
                        if (Month.from(newTemporal) != myMonth) continue;
                        dates.add(newTemporal);
                    }
                    if (((List)this.getValue()).size() > 1) {
                        Collections.sort(dates, DateTimeUtilities.TEMPORAL_COMPARATOR);
                    }
                    return dates.stream();
                });
            }
            case YEARS: {
                return inStream.flatMap(date -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    for (ByDayPair byDayPair : (List)this.getValue()) {
                        Temporal newDate;
                        if (byDayPair.ordinal == 0) {
                            newDate = date.with(TemporalAdjusters.firstDayOfYear()).with(TemporalAdjusters.nextOrSame(byDayPair.dayOfWeek));
                            while (Year.from(newDate).equals(Year.from(date))) {
                                dates.add(newDate);
                                newDate = newDate.plus(1L, ChronoUnit.WEEKS);
                            }
                            continue;
                        }
                        newDate = date.with(this.dayOfWeekInYear(byDayPair.ordinal, byDayPair.dayOfWeek));
                        dates.add(newDate);
                    }
                    if (((List)this.getValue()).size() > 1) {
                        Collections.sort(dates, DateTimeUtilities.TEMPORAL_COMPARATOR);
                    }
                    return dates.stream();
                });
            }
        }
        throw new RuntimeException("Not implemented ChronoUnit: " + chronoUnit);
    }

    private TemporalAdjuster dayOfWeekInYear(int ordinal, DayOfWeek dayOfWeek) {
        int dowValue = dayOfWeek.getValue();
        return temporal -> {
            Temporal temp = ordinal > 0 ? temporal.with(TemporalAdjusters.firstDayOfYear()) : temporal.plus(1L, ChronoUnit.YEARS).with(TemporalAdjusters.firstDayOfYear());
            int curDow = temp.get(ChronoField.DAY_OF_WEEK);
            int dowDiff = (dowValue - curDow + 7) % 7;
            dowDiff = ordinal > 0 ? dowDiff + (ordinal - 1) * 7 : dowDiff + ordinal * 7;
            return temp.plus(dowDiff, ChronoUnit.DAYS);
        };
    }

    @Override
    protected List<VElementBase.Message> parseContent(String dayPairs) {
        String valueString = ByDay.extractValue(dayPairs);
        ArrayList<ByDayPair> dayPairsList = new ArrayList<ByDayPair>();
        Pattern p = Pattern.compile("(-?[0-9]+)?([A-Z]{2})");
        Matcher m = p.matcher(valueString);
        while (m.find()) {
            String token = m.group();
            if (token.matches("^(-?[0-9]+.*)")) {
                Matcher m2 = p.matcher(token);
                if (!m2.find()) continue;
                DayOfWeek dayOfWeek = DateTimeUtilities.dayOfWeekFromAbbreviation(m2.group(2));
                int ordinal = Integer.parseInt(m2.group(1));
                dayPairsList.add(new ByDayPair(dayOfWeek, ordinal));
                continue;
            }
            DayOfWeek dayOfWeek = DateTimeUtilities.dayOfWeekFromAbbreviation(token);
            dayPairsList.add(new ByDayPair(dayOfWeek, 0));
        }
        this.setValue(dayPairsList);
        return Collections.EMPTY_LIST;
    }

    public static ByDay parse(String content) {
        return ByDay.parse(new ByDay(), content);
    }

    public static class ByDayPair {
        private DayOfWeek dayOfWeek;
        private int ordinal = 0;

        public DayOfWeek getDayOfWeek() {
            return this.dayOfWeek;
        }

        public void setDayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public ByDayPair withDayOfWeek(DayOfWeek dayOfWeek) {
            this.setDayOfWeek(dayOfWeek);
            return this;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(int ordinal) {
            this.ordinal = ordinal;
        }

        public ByDayPair withOrdinal(int ordinal) {
            this.setOrdinal(ordinal);
            return this;
        }

        public ByDayPair(DayOfWeek dayOfWeek, int ordinal) {
            this.dayOfWeek = dayOfWeek;
            this.ordinal = ordinal;
        }

        public ByDayPair() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ByDayPair testObj = (ByDayPair)obj;
            return this.dayOfWeek == testObj.dayOfWeek && this.ordinal == testObj.ordinal;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.dayOfWeek.hashCode();
            hash = 31 * hash + this.ordinal;
            return hash;
        }

        public String toString() {
            return super.toString() + ", " + this.getDayOfWeek() + ", " + this.getOrdinal();
        }
    }
}

