/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.descriptive;

import java.net.URI;
import java.util.List;
import jfxtras.icalendarfx.parameters.Encoding;
import jfxtras.icalendarfx.parameters.FormatType;
import jfxtras.icalendarfx.properties.PropAttachment;
import jfxtras.icalendarfx.properties.VPropertyBase;
import jfxtras.icalendarfx.properties.ValueType;

public class Attachment<T>
extends VPropertyBase<T, Attachment<T>>
implements PropAttachment<T> {
    private FormatType formatType;
    private Encoding encoding;

    @Override
    public FormatType getFormatType() {
        return this.formatType;
    }

    @Override
    public void setFormatType(FormatType formatType) {
        this.orderChild(formatType);
        this.formatType = formatType;
    }

    public Attachment<T> withFormatType(FormatType format) {
        this.setFormatType(format);
        return this;
    }

    public Attachment<T> withFormatType(String format) {
        this.setFormatType(FormatType.parse(format));
        return this;
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(Encoding encoding) {
        if (encoding.getValue() != Encoding.EncodingType.BASE64) {
            throw new IllegalArgumentException("Attachment property only allows ENCODING to be set to" + Encoding.EncodingType.BASE64);
        }
        this.orderChild(encoding);
        this.encoding = encoding;
    }

    public Attachment<T> withEncoding(Encoding encoding) {
        this.setEncoding(encoding);
        return this;
    }

    public Attachment<T> withEncoding(Encoding.EncodingType encoding) {
        this.setEncoding(new Encoding(encoding));
        return this;
    }

    public Attachment(Class<T> clazz, String contentLine) {
        super(clazz, contentLine);
        clazz.cast(this.getValue());
    }

    public Attachment(Attachment<T> source) {
        super(source);
    }

    public Attachment(T value) {
        super(value);
    }

    public Attachment() {
    }

    @Override
    protected void setConverterByClass(Class<T> clazz) {
        if (clazz.equals(URI.class)) {
            this.setConverter(ValueType.UNIFORM_RESOURCE_IDENTIFIER.getConverter());
        } else if (clazz.equals(String.class)) {
            this.setConverter(ValueType.BINARY.getConverter());
        } else {
            throw new IllegalArgumentException("Only parameterized types of URI and String supported.");
        }
    }

    @Override
    public List<String> errors() {
        boolean isBinaryValue;
        boolean isBase64Type;
        List<String> errors = super.errors();
        boolean bl = this.getEncoding() == null ? false : (isBase64Type = this.getEncoding().getValue() != Encoding.EncodingType.BASE64);
        boolean bl2 = this.getValueType() == null ? false : (isBinaryValue = this.getValueType().getValue() != ValueType.BINARY);
        if (isBinaryValue && !isBase64Type) {
            errors.add("If value is BINARY then encoding MUST be BASE64 not:" + this.getEncoding().getValue());
        }
        return errors;
    }

    public static <U> Attachment<U> parse(String content) {
        return Attachment.parse(new Attachment(), content);
    }
}

