/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties;

import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.icalendarfx.utilities.DefaultStringConverter;
import jfxtras.icalendarfx.utilities.DoubleStringConverter;
import jfxtras.icalendarfx.utilities.IntegerStringConverter;
import jfxtras.icalendarfx.utilities.StringConverter;
import jfxtras.icalendarfx.utilities.StringConverters;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueType {
    BINARY("BINARY", Arrays.asList(String.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new DefaultStringConverter();
        }
    }
    ,
    BOOLEAN("BOOLEAN", Arrays.asList(Boolean.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return object.toString().toUpperCase();
                }

                @Override
                public T fromString(String string) {
                    return Boolean.parseBoolean(string);
                }
            };
        }
    }
    ,
    CALENDAR_USER_ADDRESS("CAL-ADDRESS", Arrays.asList(URI.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriConverterNoQuotes();
        }
    }
    ,
    DATE("DATE", Arrays.asList(LocalDate.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return DateTimeUtilities.temporalToString((LocalDate)object);
                }

                @Override
                public T fromString(String string) {
                    return LocalDate.parse(string, DateTimeUtilities.LOCAL_DATE_FORMATTER);
                }
            };
        }
    }
    ,
    DATE_TIME("DATE-TIME", Arrays.asList(LocalDateTime.class, ZonedDateTime.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return DateTimeUtilities.temporalToString((Temporal)object);
                }

                @Override
                public T fromString(String string) {
                    return DateTimeUtilities.temporalFromString(string);
                }
            };
        }
    }
    ,
    DURATION("DURATION", Arrays.asList(Duration.class, Period.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    Object s = object.toString();
                    if (((String)s).contains("-")) {
                        s = "-" + ((String)s).replaceFirst("-", "");
                    }
                    return s;
                }

                @Override
                public T fromString(String string) {
                    if (string.contains("T")) {
                        return Duration.parse(string);
                    }
                    return Period.parse(string);
                }
            };
        }
    }
    ,
    FLOAT("FLOAT", Arrays.asList(Double.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new DoubleStringConverter();
        }
    }
    ,
    INTEGER("INTEGER", Arrays.asList(Integer.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new IntegerStringConverter();
        }
    }
    ,
    PERIOD("PERIOD", Arrays.asList(List.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return object.toString();
                }

                @Override
                public T fromString(String string) {
                    throw new RuntimeException("not implemented");
                }
            };
        }
    }
    ,
    RECURRENCE_RULE("RECUR", Arrays.asList(RecurrenceRuleValue.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((VElement)object).toString();
                }

                @Override
                public T fromString(String string) {
                    return RecurrenceRuleValue.parse(string);
                }
            };
        }

        @Override
        public <T> List<String> createErrorList(T value) {
            if (value != null) {
                return ((RecurrenceRuleValue)value).errors();
            }
            return Collections.emptyList();
        }
    }
    ,
    TEXT("TEXT", Arrays.asList(String.class, ZoneId.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    if (object == null) {
                        return "";
                    }
                    String line = object.toString();
                    StringBuilder builder = new StringBuilder(line.length() + 20);
                    for (int i = 0; i < line.length(); ++i) {
                        char myChar = line.charAt(i);
                        for (int j = 0; j < REPLACEMENT_CHARACTERS.length; ++j) {
                            if (myChar != REPLACEMENT_CHARACTERS[j]) continue;
                            builder.append('\\');
                            myChar = SPECIAL_CHARACTERS[j];
                            break;
                        }
                        builder.append(myChar);
                    }
                    return builder.toString();
                }

                @Override
                public T fromString(String string) {
                    StringBuilder builder = new StringBuilder(string.length());
                    for (int i = 0; i < string.length(); ++i) {
                        char charToAdd = string.charAt(i);
                        if (string.charAt(i) == '\\') {
                            char nextChar = string.charAt(i + 1);
                            for (int j = 0; j < SPECIAL_CHARACTERS.length; ++j) {
                                if (nextChar != SPECIAL_CHARACTERS[j]) continue;
                                charToAdd = REPLACEMENT_CHARACTERS[j];
                                if (charToAdd == '\n' && IS_WINDOWS) {
                                    builder.append('\r');
                                }
                                ++i;
                                break;
                            }
                        }
                        builder.append(charToAdd);
                    }
                    return builder.toString();
                }
            };
        }
    }
    ,
    TIME("TIME", Arrays.asList(LocalTime.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            throw new RuntimeException("not implemented");
        }
    }
    ,
    UNIFORM_RESOURCE_IDENTIFIER("URI", Arrays.asList(URI.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriConverterNoQuotes();
        }
    }
    ,
    UTC_OFFSET("UTC-OFFSET", Arrays.asList(ZoneOffset.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ZONE_OFFSET_FORMATTER.format((TemporalAccessor)object);
                }

                @Override
                public T fromString(String string) {
                    return ZoneOffset.of(string);
                }
            };
        }
    }
    ,
    UNKNOWN("UNKNOWN", Arrays.asList(Object.class)){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new DefaultStringConverter();
        }
    };

    private static final boolean IS_WINDOWS;
    private static final char[] SPECIAL_CHARACTERS;
    private static final char[] REPLACEMENT_CHARACTERS;
    private static final DateTimeFormatter ZONE_OFFSET_FORMATTER;
    private static Map<String, ValueType> enumFromNameMap;
    private String name;
    List<Class<?>> allowedClasses;

    private static Map<String, ValueType> makeEnumFromNameMap() {
        HashMap<String, ValueType> map = new HashMap<String, ValueType>();
        ValueType[] values = ValueType.values();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i].toString(), values[i]);
        }
        return map;
    }

    public static ValueType enumFromName(String propertyName) {
        ValueType type = enumFromNameMap.get(propertyName.toUpperCase());
        return type == null ? UNKNOWN : type;
    }

    public String toString() {
        return this.name;
    }

    public List<Class<?>> allowedClasses() {
        return this.allowedClasses;
    }

    private ValueType(String name, List<Class<?>> allowedClasses) {
        this.name = name;
        this.allowedClasses = allowedClasses;
    }

    public abstract <T> StringConverter<T> getConverter();

    public <T> List<String> createErrorList(T value) {
        return null;
    }

    static {
        IS_WINDOWS = System.getProperty("os.name").equals("Windows");
        SPECIAL_CHARACTERS = new char[]{',', ';', '\\', 'n', 'N'};
        REPLACEMENT_CHARACTERS = new char[]{',', ';', '\\', '\n', '\n'};
        ZONE_OFFSET_FORMATTER = new DateTimeFormatterBuilder().appendOffset("+HHMMss", "+0000").toFormatter();
        enumFromNameMap = ValueType.makeEnumFromNameMap();
    }
}

