/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import jfxtras.icalendarfx.properties.VPropertyBase;

public abstract class PropBaseUTC<U extends PropBaseUTC<U>>
extends VPropertyBase<ZonedDateTime, U> {
    protected PropBaseUTC() {
    }

    public PropBaseUTC(ZonedDateTime temporal) {
        super(temporal);
    }

    public PropBaseUTC(PropBaseUTC<U> source) {
        super(source);
    }

    @Override
    public void setValue(ZonedDateTime value) {
        ZoneId zone = value.getZone();
        if (!zone.equals(ZoneId.of("Z"))) {
            throw new DateTimeException("Unsupported ZoneId:" + zone + " only Z supported");
        }
        super.setValue(value);
    }

    @Override
    public boolean isValid() {
        ZoneId zone = ((ZonedDateTime)this.getValue()).getZone();
        if (!zone.equals(ZoneId.of("Z"))) {
            return false;
        }
        return super.isValid();
    }
}

