/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.parameters.AlarmTriggerRelationship;
import jfxtras.icalendarfx.parameters.AlternateText;
import jfxtras.icalendarfx.parameters.CalendarUser;
import jfxtras.icalendarfx.parameters.CommonName;
import jfxtras.icalendarfx.parameters.Delegatees;
import jfxtras.icalendarfx.parameters.Delegators;
import jfxtras.icalendarfx.parameters.DirectoryEntry;
import jfxtras.icalendarfx.parameters.Encoding;
import jfxtras.icalendarfx.parameters.FormatType;
import jfxtras.icalendarfx.parameters.FreeBusyType;
import jfxtras.icalendarfx.parameters.GroupMembership;
import jfxtras.icalendarfx.parameters.Language;
import jfxtras.icalendarfx.parameters.NonStandardParameter;
import jfxtras.icalendarfx.parameters.ParticipationRole;
import jfxtras.icalendarfx.parameters.ParticipationStatus;
import jfxtras.icalendarfx.parameters.RSVP;
import jfxtras.icalendarfx.parameters.Range;
import jfxtras.icalendarfx.parameters.Relationship;
import jfxtras.icalendarfx.parameters.SentBy;
import jfxtras.icalendarfx.parameters.TimeZoneIdentifierParameter;
import jfxtras.icalendarfx.parameters.VParameter;
import jfxtras.icalendarfx.parameters.ValueParameter;
import jfxtras.icalendarfx.properties.ValueType;
import jfxtras.icalendarfx.utilities.StringConverter;
import jfxtras.icalendarfx.utilities.StringConverters;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VParameterElement {
    ALTERNATE_TEXT_REPRESENTATION("ALTREP", AlternateText.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriConverterWithQuotes();
        }
    }
    ,
    COMMON_NAME("CN", CommonName.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.defaultStringConverterWithQuotes();
        }
    }
    ,
    CALENDAR_USER_TYPE("CUTYPE", CalendarUser.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((CalendarUser.CalendarUserType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)CalendarUser.CalendarUserType.valueOfWithUnknown(string.toUpperCase());
                }
            };
        }
    }
    ,
    DELEGATORS("DELEGATED-FROM", Delegators.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriListConverter();
        }
    }
    ,
    DELEGATEES("DELEGATED-TO", Delegatees.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriListConverter();
        }
    }
    ,
    DIRECTORY_ENTRY_REFERENCE("DIR", DirectoryEntry.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriConverterWithQuotes();
        }
    }
    ,
    INLINE_ENCODING("ENCODING", Encoding.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((Encoding.EncodingType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)Encoding.EncodingType.enumFromName(string.toUpperCase());
                }
            };
        }
    }
    ,
    FORMAT_TYPE("FMTTYPE", FormatType.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.defaultStringConverterWithQuotes();
        }
    }
    ,
    FREE_BUSY_TIME_TYPE("FBTYPE", FreeBusyType.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((FreeBusyType.FreeBusyTypeEnum)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)FreeBusyType.FreeBusyTypeEnum.enumFromName(string.toUpperCase());
                }
            };
        }
    }
    ,
    LANGUAGE("LANGUAGE", Language.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.defaultStringConverterWithQuotes();
        }
    }
    ,
    GROUP_OR_LIST_MEMBERSHIP("MEMBER", GroupMembership.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriListConverter();
        }
    }
    ,
    NON_STANDARD("X-", NonStandardParameter.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.defaultStringConverterWithQuotes();
        }
    }
    ,
    PARTICIPATION_STATUS("PARTSTAT", ParticipationStatus.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((ParticipationStatus.ParticipationStatusType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)ParticipationStatus.ParticipationStatusType.enumFromName(string.toUpperCase());
                }
            };
        }
    }
    ,
    RECURRENCE_IDENTIFIER_RANGE("RANGE", Range.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((Range.RangeType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)Range.RangeType.enumFromName(string.toUpperCase());
                }
            };
        }
    }
    ,
    ALARM_TRIGGER_RELATIONSHIP("RELATED", AlarmTriggerRelationship.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((AlarmTriggerRelationship.AlarmTriggerRelationshipType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)AlarmTriggerRelationship.AlarmTriggerRelationshipType.valueOf(string.toUpperCase());
                }
            };
        }
    }
    ,
    RELATIONSHIP_TYPE("RELTYPE", Relationship.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((Relationship.RelationshipType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)Relationship.RelationshipType.valueOfWithUnknown(string.toUpperCase());
                }
            };
        }
    }
    ,
    PARTICIPATION_ROLE("ROLE", ParticipationRole.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((ParticipationRole.ParticipationRoleType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)ParticipationRole.ParticipationRoleType.enumFromName(string.toUpperCase());
                }
            };
        }
    }
    ,
    RSVP_EXPECTATION("RSVP", RSVP.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.booleanConverter();
        }
    }
    ,
    SENT_BY("SENT-BY", SentBy.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return StringConverters.uriConverterWithQuotes();
        }
    }
    ,
    TIME_ZONE_IDENTIFIER("TZID", TimeZoneIdentifierParameter.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((ZoneId)object).toString();
                }

                @Override
                public T fromString(String string) {
                    return ZoneId.of(string);
                }
            };
        }
    }
    ,
    VALUE_DATA_TYPES("VALUE", ValueParameter.class){

        @Override
        public <T> StringConverter<T> getConverter() {
            return new StringConverter<T>(){

                @Override
                public String toString(T object) {
                    return ((ValueType)((Object)object)).toString();
                }

                @Override
                public T fromString(String string) {
                    return (Object)ValueType.enumFromName(string.toUpperCase());
                }
            };
        }
    };

    private static Map<String, VParameterElement> enumFromNameMap;
    private static Map<Class<? extends VParameter<?>>, VParameterElement> enumFromClassMap;
    private String name;
    private Class<? extends VParameter<?>> myClass;

    private static Map<String, VParameterElement> makeEnumFromNameMap() {
        HashMap<String, VParameterElement> map = new HashMap<String, VParameterElement>();
        VParameterElement[] values = VParameterElement.values();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i].toString(), values[i]);
        }
        return map;
    }

    public static VParameterElement enumFromName(String parameterName) {
        boolean isLongEnough = parameterName.length() > 2;
        boolean isNonStanderd = isLongEnough ? parameterName.substring(0, NON_STANDARD.toString().length()).equals(NON_STANDARD.toString()) : false;
        VParameterElement prop = isNonStanderd ? NON_STANDARD : enumFromNameMap.get(parameterName);
        return prop;
    }

    private static Map<Class<? extends VParameter<?>>, VParameterElement> makeEnumFromClassMap() {
        HashMap map = new HashMap();
        VParameterElement[] values = VParameterElement.values();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i].myClass, values[i]);
        }
        return map;
    }

    public static VParameterElement enumFromClass(Class<? extends VElement> myClass) {
        VParameterElement p = enumFromClassMap.get(myClass);
        if (p == null) {
            throw new IllegalArgumentException(VParameterElement.class.getSimpleName() + " does not contain an enum to match the class:" + myClass.getSimpleName());
        }
        return p;
    }

    public Class<? extends VParameter<?>> elementClass() {
        return this.myClass;
    }

    public String toString() {
        return this.name;
    }

    private VParameterElement(String name, Class<? extends VParameter<?>> myClass) {
        this.name = name;
        this.myClass = myClass;
    }

    static String extractValue(String content) {
        int equalsIndex = content.indexOf(61);
        return equalsIndex > 0 ? content.substring(equalsIndex + 1) : content;
    }

    public abstract <T> StringConverter<T> getConverter();

    static {
        enumFromNameMap = VParameterElement.makeEnumFromNameMap();
        enumFromClassMap = VParameterElement.makeEnumFromClassMap();
    }
}

