/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.parameters.VParameterBase;
import jfxtras.icalendarfx.utilities.StringConverter;
import jfxtras.icalendarfx.utilities.StringConverters;

public class NonStandardParameter
extends VParameterBase<NonStandardParameter, String> {
    private static final StringConverter<String> CONVERTER = StringConverters.defaultStringConverterWithQuotes();
    String name;

    @Override
    public String name() {
        return this.name;
    }

    public NonStandardParameter(String content) {
        super(CONVERTER);
        this.construct(content);
    }

    private void construct(String content) {
        int equalsIndex = content.indexOf(61);
        this.name = equalsIndex >= 0 ? content.substring(0, equalsIndex) : content;
        String value = equalsIndex >= 0 ? content.substring(equalsIndex + 1) : null;
        this.setValue(value);
    }

    public NonStandardParameter(NonStandardParameter source) {
        super(source, CONVERTER);
        this.name = source.name;
    }

    public NonStandardParameter() {
        super(CONVERTER);
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        this.construct(content);
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.name() != null && !this.name().substring(0, 2).equals("X-")) {
            errors.add(this.name() + " is not a proper non-standard parameter name.  It must begin with X-");
        }
        return errors;
    }

    @Override
    public String toString() {
        return this.getValue() != null ? this.name() + "=" + (String)this.getValue() : null;
    }

    public static NonStandardParameter parse(String content) {
        return NonStandardParameter.parse(new NonStandardParameter(), content);
    }
}

