/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.itip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VPersonal;
import jfxtras.icalendarfx.itip.ProcessPublish;
import jfxtras.icalendarfx.properties.component.relationship.UniqueIdentifier;

public class ProcessRequest
extends ProcessPublish {
    @Override
    public List<String> process(VCalendar mainVCalendar, VCalendar iTIPMessage) {
        ArrayList<String> log = new ArrayList<String>();
        Iterator componentIterator = iTIPMessage.childrenUnmodifiable().stream().filter(c -> c instanceof VComponent).map(c -> (VComponent)c).iterator();
        while (componentIterator.hasNext()) {
            VPersonal myComponent = (VPersonal)componentIterator.next();
            if (myComponent.getAttendees() != null) {
                throw new IllegalArgumentException("Can't process REQUEST, handling Attendees is not implemented");
            }
            UniqueIdentifier uid = myComponent.getUniqueIdentifier();
            if (uid == null) {
                throw new IllegalArgumentException("Can't process REQUEST, VComponent has null UID");
            }
            boolean isUIDPresent = mainVCalendar.getVComponents(myComponent).stream().map(v -> (VPersonal)v).anyMatch(v -> v.getUniqueIdentifier().equals(uid));
            if (isUIDPresent) continue;
            throw new IllegalArgumentException("Can't process REQUEST, VComponent UID is not present in main VCalendar");
        }
        log.addAll(super.process(mainVCalendar, iTIPMessage));
        return log;
    }
}

