/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VCommon;
import jfxtras.icalendarfx.properties.component.descriptive.Comment;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public abstract class VPrimary<T>
extends VCommon<T> {
    private List<Comment> comments;
    private DateTimeStart dateTimeStart;
    public static final Comparator<? super VPrimary<?>> DTSTART_COMPARATOR = (v1, v2) -> {
        Temporal t1 = (Temporal)v1.getDateTimeStart().getValue();
        Temporal t2 = (Temporal)v2.getDateTimeStart().getValue();
        return DateTimeUtilities.TEMPORAL_COMPARATOR2.compare(t1, t2);
    };

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        if (this.comments != null) {
            this.comments.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.comments = comments;
        if (comments != null) {
            comments.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withComments(List<Comment> comments) {
        if (this.getComments() == null) {
            this.setComments(new ArrayList<Comment>());
        }
        this.getComments().addAll(comments);
        if (comments != null) {
            comments.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withComments(String ... comments) {
        List<Comment> list = Arrays.stream(comments).map(c -> Comment.parse(c)).collect(Collectors.toList());
        return this.withComments(list);
    }

    public T withComments(Comment ... comments) {
        return this.withComments(Arrays.asList(comments));
    }

    @Deprecated
    void dateTimeStartListenerHook() {
    }

    public DateTimeStart getDateTimeStart() {
        return this.dateTimeStart;
    }

    public void setDateTimeStart(DateTimeStart dateTimeStart) {
        this.orderChild(this.dateTimeStart, (VChild)dateTimeStart);
        this.dateTimeStart = dateTimeStart;
    }

    public void setDateTimeStart(String dateTimeStart) {
        this.setDateTimeStart(DateTimeStart.parse(dateTimeStart));
    }

    public void setDateTimeStart(Temporal temporal) {
        this.setDateTimeStart(new DateTimeStart(temporal));
    }

    public T withDateTimeStart(DateTimeStart dateTimeStart) {
        this.setDateTimeStart(dateTimeStart);
        return (T)this;
    }

    public T withDateTimeStart(String dateTimeStart) {
        this.setDateTimeStart(dateTimeStart);
        return (T)this;
    }

    public T withDateTimeStart(Temporal dateTimeStart) {
        this.setDateTimeStart(dateTimeStart);
        return (T)this;
    }

    public boolean isWholeDay() {
        return !((Temporal)this.getDateTimeStart().getValue()).isSupported(ChronoUnit.NANOS);
    }

    VPrimary() {
    }

    public VPrimary(VPrimary<T> source) {
        super(source);
    }
}

