/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VAttendee;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.properties.component.change.DateTimeStamp;
import jfxtras.icalendarfx.properties.component.misc.RequestStatus;
import jfxtras.icalendarfx.properties.component.relationship.Attendee;
import jfxtras.icalendarfx.properties.component.relationship.Organizer;
import jfxtras.icalendarfx.properties.component.relationship.UniformResourceLocator;
import jfxtras.icalendarfx.properties.component.relationship.UniqueIdentifier;
import jfxtras.icalendarfx.utilities.Callback;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public abstract class VPersonal<T>
extends VPrimary<T>
implements VAttendee<T> {
    private List<Attendee> attendees;
    private DateTimeStamp dateTimeStamp;
    private Organizer organizer;
    private List<RequestStatus> requestStatus;
    private UniqueIdentifier uniqueIdentifier;
    private static Integer nextKey = 0;
    private Callback<Void, String> uidGeneratorCallback = Void2 -> {
        String dateTime = DateTimeUtilities.LOCAL_DATE_TIME_FORMATTER.format(LocalDateTime.now());
        String domain = "jfxtras.org";
        Integer n = nextKey;
        nextKey = nextKey + 1;
        return dateTime + "-" + n + domain;
    };
    private UniformResourceLocator url;

    @Override
    public List<Attendee> getAttendees() {
        return this.attendees;
    }

    @Override
    public void setAttendees(List<Attendee> attendees) {
        if (this.attendees != null) {
            this.attendees.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.attendees = attendees;
        if (attendees != null) {
            attendees.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public DateTimeStamp getDateTimeStamp() {
        return this.dateTimeStamp;
    }

    public void setDateTimeStamp(String dateTimeStamp) {
        this.setDateTimeStamp(DateTimeStamp.parse(dateTimeStamp));
    }

    public void setDateTimeStamp(DateTimeStamp dateTimeStamp) {
        this.orderChild(this.dateTimeStamp, (VChild)dateTimeStamp);
        this.dateTimeStamp = dateTimeStamp;
    }

    public void setDateTimeStamp(ZonedDateTime dateTimeStamp) {
        this.setDateTimeStamp(new DateTimeStamp(dateTimeStamp));
    }

    public T withDateTimeStamp(ZonedDateTime dateTimeStamp) {
        this.setDateTimeStamp(dateTimeStamp);
        return (T)this;
    }

    public T withDateTimeStamp(String dateTimeStamp) {
        this.setDateTimeStamp(dateTimeStamp);
        return (T)this;
    }

    public T withDateTimeStamp(DateTimeStamp dateTimeStamp) {
        this.setDateTimeStamp(dateTimeStamp);
        return (T)this;
    }

    public Organizer getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(Organizer organizer) {
        this.orderChild(this.organizer, (VChild)organizer);
        this.organizer = organizer;
    }

    public void setOrganizer(String organizer) {
        this.setOrganizer(Organizer.parse(organizer));
    }

    public T withOrganizer(String organizer) {
        this.setOrganizer(organizer);
        return (T)this;
    }

    public T withOrganizer(Organizer organizer) {
        this.setOrganizer(organizer);
        return (T)this;
    }

    public List<RequestStatus> getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(List<RequestStatus> requestStatus) {
        if (this.requestStatus != null) {
            this.requestStatus.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.requestStatus = requestStatus;
        if (requestStatus != null) {
            requestStatus.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withRequestStatus(List<RequestStatus> requestStatus) {
        if (this.getRequestStatus() == null) {
            this.setRequestStatus(new ArrayList<RequestStatus>());
        }
        this.getRequestStatus().addAll(requestStatus);
        if (requestStatus != null) {
            requestStatus.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withRequestStatus(String ... requestStatus) {
        List<RequestStatus> list = Arrays.stream(requestStatus).map(c -> RequestStatus.parse(c)).collect(Collectors.toList());
        return this.withRequestStatus(list);
    }

    public T withRequestStatus(RequestStatus ... requestStatus) {
        return this.withRequestStatus(Arrays.asList(requestStatus));
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(UniqueIdentifier uniqueIdentifier) {
        this.orderChild(this.uniqueIdentifier, (VChild)uniqueIdentifier);
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.setUniqueIdentifier(UniqueIdentifier.parse(uniqueIdentifier));
    }

    public void setUniqueIdentifier() {
        this.setUniqueIdentifier(this.getUidGeneratorCallback().call(null));
    }

    public T withUniqueIdentifier(String uniqueIdentifier) {
        this.setUniqueIdentifier(uniqueIdentifier);
        return (T)this;
    }

    public T withUniqueIdentifier(UniqueIdentifier uniqueIdentifier) {
        this.setUniqueIdentifier(uniqueIdentifier);
        return (T)this;
    }

    public T withUniqueIdentifier() {
        this.setUniqueIdentifier(this.getUidGeneratorCallback().call(null));
        return (T)this;
    }

    public Callback<Void, String> getUidGeneratorCallback() {
        return this.uidGeneratorCallback;
    }

    public void setUidGeneratorCallback(Callback<Void, String> uidCallback) {
        this.uidGeneratorCallback = uidCallback;
    }

    public T withUidGeneratorCallback(Callback<Void, String> uidCallback) {
        this.setUidGeneratorCallback(uidCallback);
        return (T)this;
    }

    public UniformResourceLocator getURL() {
        return this.url;
    }

    public void setURL(UniformResourceLocator url) {
        this.orderChild(this.url, (VChild)url);
        this.url = url;
    }

    public void setURL(String url) {
        this.setURL(UniformResourceLocator.parse(url));
    }

    public void setURL(URI url) {
        this.setURL(new UniformResourceLocator(url));
    }

    public T withURL(String url) {
        this.setURL(url);
        return (T)this;
    }

    public T withURL(URI url) {
        this.setURL(url);
        return (T)this;
    }

    public T withURL(UniformResourceLocator url) {
        this.setURL(url);
        return (T)this;
    }

    VPersonal() {
    }

    public VPersonal(VPersonal<T> source) {
        super(source);
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.getDateTimeStamp() == null) {
            errors.add("DTSTAMP is not present.  DTSTAMP is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getUniqueIdentifier() == null) {
            errors.add("UID is not present.  UID is REQUIRED and MUST NOT occur more than once");
        }
        return errors;
    }
}

