/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.VParentBase;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VComponentElement;
import jfxtras.icalendarfx.content.MultiLineContent;

public abstract class VComponentBase<T>
extends VParentBase<T>
implements VComponent {
    protected VParent parent;
    private final VComponentElement componentType = VComponentElement.fromClass(this.getClass());

    @Override
    public void setParent(VParent parent) {
        this.parent = parent;
    }

    @Override
    public VParent getParent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.componentType.toString();
    }

    VComponentBase() {
        this.contentLineGenerator = new MultiLineContent(this.orderer, "BEGIN:" + this.name(), "END:" + this.name(), 400);
    }

    VComponentBase(VComponentBase<T> source) {
        super(source);
        this.contentLineGenerator = new MultiLineContent(this.orderer, "BEGIN:" + this.name(), "END:" + this.name(), 400);
        this.setParent(source.getParent());
    }

    void addSubcomponent(VComponent subcomponent) {
    }

    @Override
    protected boolean isContentValid(String valueContent) {
        boolean isElementValid = super.isContentValid(valueContent);
        if (!isElementValid) {
            return false;
        }
        boolean isBeginPresent = valueContent.startsWith("BEGIN:" + this.name());
        if (!isBeginPresent) {
            return false;
        }
        int lastLineIndex = valueContent.lastIndexOf(System.lineSeparator());
        if (lastLineIndex == -1) {
            return false;
        }
        boolean isEndPresent = valueContent.substring(lastLineIndex).startsWith("END:" + this.name());
        return !isEndPresent;
    }
}

