/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VComponentElement;
import jfxtras.icalendarfx.parameters.VParameter;
import jfxtras.icalendarfx.parameters.VParameterElement;
import jfxtras.icalendarfx.properties.VProperty;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRuleElement;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePart;
import jfxtras.icalendarfx.utilities.Pair;

public abstract class VElementBase
implements VElement {
    protected static final String BEGIN = "BEGIN:";
    protected static final String END = "END:";
    private static final Map<Pair<Class<? extends VElement>, String>, Constructor<? extends VElement>> NO_ARG_CONSTRUCTORS = VElementBase.makeNoArgConstructorMap();
    private static final Set<String> NAMES = NO_ARG_CONSTRUCTORS.entrySet().stream().map(e -> (String)((Pair)e.getKey()).getValue()).collect(Collectors.toSet());

    protected abstract List<Message> parseContent(String var1);

    protected static void throwMessageExceptions(List<Message> messages, VElement element) throws IllegalArgumentException {
        String error = messages.stream().filter(m -> !m.message.startsWith("Unknown")).map(m -> m.element.name() + ":" + m.message).collect(Collectors.joining(System.lineSeparator()));
        if (!error.isEmpty()) {
            throw new IllegalArgumentException(error);
        }
    }

    private static Map<Pair<Class<? extends VElement>, String>, Constructor<? extends VElement>> makeNoArgConstructorMap() {
        HashMap<Pair<Class<? extends VElement>, String>, Constructor<? extends VElement>> map = new HashMap<Pair<Class<? extends VElement>, String>, Constructor<? extends VElement>>();
        VComponentElement[] values0 = VComponentElement.values();
        Arrays.stream(values0).forEach(v -> {
            Pair<Class<VComponent>, String> key = new Pair<Class<VComponent>, String>(VComponent.class, v.toString());
            try {
                Constructor<? extends VComponent> constructor = v.elementClass().getConstructor(new Class[0]);
                map.put(key, constructor);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        });
        VPropertyElement[] values1 = VPropertyElement.values();
        Arrays.stream(values1).forEach(v -> {
            Pair<Class<VProperty>, String> key = new Pair<Class<VProperty>, String>(VProperty.class, v.toString());
            try {
                Constructor<? extends VProperty> constructor = v.elementClass().getConstructor(new Class[0]);
                map.put(key, constructor);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        });
        VParameterElement[] values2 = VParameterElement.values();
        Arrays.stream(values2).forEach(v -> {
            Pair<Class<VParameter>, String> key = new Pair<Class<VParameter>, String>(VParameter.class, v.toString());
            try {
                Constructor<? extends VParameter<?>> constructor = v.elementClass().getConstructor(new Class[0]);
                map.put(key, constructor);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        });
        RRuleElement[] values3 = RRuleElement.values();
        Arrays.stream(values3).forEach(v -> {
            Pair<Class<RRulePart>, String> key = new Pair<Class<RRulePart>, String>(RRulePart.class, v.toString());
            try {
                Constructor<? extends RRulePart<?>> constructor = v.elementClass().getConstructor(new Class[0]);
                map.put(key, constructor);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        });
        return map;
    }

    public static VChild newEmptyVElement(Class<? extends VElement> superclass, String name) {
        try {
            if (name == null) {
                return null;
            }
            String name2 = name.startsWith("X-") ? "X-" : name;
            Constructor<? extends VElement> constructor = NO_ARG_CONSTRUCTORS.get(new Pair<Class<? extends VElement>, String>(superclass, name2));
            if (constructor == null) {
                return null;
            }
            return (VChild)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static <T extends VElementBase> T parse(T element, String valueContent) {
        if (valueContent == null) {
            return null;
        }
        boolean isContentValid = element.isContentValid(valueContent);
        if (!isContentValid) {
            throw new IllegalArgumentException("Invalid element:" + valueContent);
        }
        List<Message> messages = element.parseContent(valueContent);
        VElementBase.throwMessageExceptions(messages, element);
        return element;
    }

    protected boolean isContentValid(String valueContent) {
        return true;
    }

    protected static String elementName(String content) {
        boolean isMultiline;
        if (content == null) {
            return null;
        }
        int indexOfBegin = content.indexOf(BEGIN);
        boolean bl = isMultiline = indexOfBegin != -1;
        if (isMultiline) {
            int indexOfLineSeparator = content.indexOf(System.lineSeparator());
            if (indexOfLineSeparator == -1) {
                return content.substring(indexOfBegin + BEGIN.length());
            }
            return content.substring(indexOfBegin + BEGIN.length(), indexOfLineSeparator);
        }
        int i1 = content.indexOf(58);
        i1 = i1 == -1 ? Integer.MAX_VALUE : i1;
        int i2 = content.indexOf(59);
        int i = Math.min(i1, i2 = i2 == -1 ? Integer.MAX_VALUE : i2);
        if (i == Integer.MAX_VALUE) {
            return null;
        }
        String possibleName = content.substring(0, i).toUpperCase();
        boolean isNonStandard = possibleName.startsWith("X-");
        if (isNonStandard) {
            return possibleName;
        }
        boolean isStandard = NAMES.contains(possibleName);
        if (isStandard) {
            return possibleName;
        }
        return null;
    }

    protected static class Message {
        public VElement element;
        public String message;
        public MessageEffect effect;

        public Message(VElement element, String message, MessageEffect effect) {
            this.element = element;
            this.message = message;
            this.effect = effect;
        }

        public String toString() {
            return "Message [element=" + this.element + ", message=" + this.message + ", effect=" + this.effect + "]";
        }
    }

    public static enum MessageEffect {
        MESSAGE_ONLY,
        THROW_EXCEPTION;

    }
}

