/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.jfrog.storage.util.DbUtils;

public final class ResultSetWrapper
implements InvocationHandler {
    private final DataSource ds;
    private final Connection con;
    private final Statement stmt;
    private final ResultSet rs;
    private final boolean resetIsolationLevel;

    public static ResultSet newInstance(Connection con, Statement stmt, ResultSet rs, DataSource ds, boolean resetIsolationLevel) {
        ResultSetWrapper proxy = new ResultSetWrapper(con, stmt, rs, ds, resetIsolationLevel);
        return (ResultSet)Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)proxy);
    }

    private ResultSetWrapper(Connection con, Statement stmt, ResultSet rs, DataSource ds, boolean resetIsolationLevel) {
        this.con = con;
        this.stmt = stmt;
        this.rs = rs;
        this.ds = ds;
        this.resetIsolationLevel = resetIsolationLevel;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            if (this.resetIsolationLevel && this.con != null) {
                this.closeAndResetIsolationLevel();
            } else {
                DbUtils.close(this.con, this.stmt, this.rs, this.ds);
            }
            return null;
        }
        return method.invoke((Object)this.rs, args);
    }

    private void closeAndResetIsolationLevel() throws SQLException {
        DbUtils.close(this.rs);
        this.con.setTransactionIsolation(2);
        DbUtils.close(this.con, this.stmt, null, this.ds);
    }
}

