/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.jfrog.storage.DbProperties;
import org.jfrog.storage.DbType;
import org.jfrog.storage.JFrogDataSource;
import org.jfrog.storage.wrapper.JFrogConnectionWrapper;

public class JFrogDataSourceWrapper
implements InvocationHandler {
    private ExecutorService executorService;
    private DataSource dataSource;
    private DbType dbType;
    private boolean networkTimeoutEnabled;

    private JFrogDataSourceWrapper(DataSource dataSource, DbProperties dbProps) {
        this.dataSource = dataSource;
        this.dbType = dbProps.getDbType();
        this.networkTimeoutEnabled = dbProps.getBooleanProperty("networkTimeoutEnabled", true);
        if (this.networkTimeoutEnabled) {
            this.executorService = new ThreadPoolExecutor(0, dbProps.getMaxActiveConnections(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    public static JFrogDataSource newInstance(JFrogDataSource dataSource, DbProperties dbProps) {
        JFrogDataSourceWrapper proxy = new JFrogDataSourceWrapper(dataSource, dbProps);
        return (JFrogDataSource)Proxy.newProxyInstance(dataSource.getClass().getClassLoader(), new Class[]{JFrogDataSource.class}, (InvocationHandler)proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getConnection".equals(method.getName())) {
            return this.getConnection();
        }
        if ("getExecutorService".equalsIgnoreCase(method.getName())) {
            return this.executorService;
        }
        if ("unwrap".equalsIgnoreCase(method.getName())) {
            return this.unwrap((Class)args[0]);
        }
        if ("isWrapperFor".equalsIgnoreCase(method.getName())) {
            return this.isWrapperFor((Class)args[0]);
        }
        if ("close".equalsIgnoreCase(method.getName())) {
            method.invoke((Object)this.dataSource, args);
            this.close();
            return null;
        }
        return method.invoke((Object)this.dataSource, args);
    }

    private Connection getConnection() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        Connection connection = JFrogConnectionWrapper.newInstance(conn, this.dbType, this.networkTimeoutEnabled);
        connection.setNetworkTimeout(this.executorService, 3600000);
        return connection;
    }

    private void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this.dataSource)) {
            return aClass.cast(this.dataSource);
        }
        throw new SQLException("DataSource of type [" + this.dataSource.getClass().getName() + "] cannot be unwrapped as [" + aClass.getName() + "]");
    }

    private boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this.dataSource);
    }
}

