/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.wrapper;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.jfrog.storage.DbType;

public class JFrogConnectionWrapper
implements InvocationHandler {
    private Connection connection;
    private DbType dbType;
    private boolean networkTimeoutEnabled;
    private int networkTimeoutConfigured;

    private JFrogConnectionWrapper(Connection connection, DbType dbType, boolean networkTimeoutEnabled) {
        this.connection = connection;
        this.dbType = dbType;
        this.networkTimeoutEnabled = networkTimeoutEnabled;
    }

    public static Connection newInstance(Connection con, DbType dbType, boolean networkTimeoutEnabled) {
        JFrogConnectionWrapper proxy = new JFrogConnectionWrapper(con, dbType, networkTimeoutEnabled);
        return (Connection)Proxy.newProxyInstance(con.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)proxy);
    }

    private void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.networkTimeoutEnabled || this.dbType == DbType.DERBY || this.networkTimeoutConfigured == milliseconds) {
            return;
        }
        if (this.isUnsupportedOracleDriver() || this.isUnsupportedMSSQLDriver()) {
            return;
        }
        this.connection.setNetworkTimeout(executor, milliseconds);
        this.networkTimeoutConfigured = milliseconds;
    }

    private int getNetworkTimeout() throws SQLException {
        if (!this.networkTimeoutEnabled || this.dbType == DbType.DERBY) {
            return 0;
        }
        if (this.isUnsupportedOracleDriver() || this.isUnsupportedMSSQLDriver()) {
            return 0;
        }
        return this.connection.getNetworkTimeout();
    }

    private boolean isUnsupportedOracleDriver() throws SQLException {
        return this.dbType == DbType.ORACLE && this.connection.getMetaData().getDriverMajorVersion() <= 11;
    }

    private boolean isUnsupportedMSSQLDriver() throws SQLException {
        return this.dbType == DbType.MSSQL && this.connection.getMetaData().getDriverMajorVersion() < 6;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setNetworkTimeout".equals(method.getName())) {
            if (args.length != 2) {
                throw new IOException("Expected 2 arguments, however, got: " + args.length);
            }
            this.setNetworkTimeout((Executor)args[0], (Integer)args[1]);
            return null;
        }
        if ("getNetworkTimeout".equals(method.getName())) {
            return this.getNetworkTimeout();
        }
        return method.invoke((Object)this.connection, args);
    }
}

