/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.wrapper;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jfrog.storage.StringInputStream;

public class BlobWrapper {
    public static final int LENGTH_UNKNOWN = -1;
    private final InputStream in;
    private final long length;

    public BlobWrapper(InputStream in) {
        this(in, -1L);
    }

    public BlobWrapper(InputStream in, long length) {
        if (in == null) {
            throw new NullPointerException("Input stream cannot be null");
        }
        this.in = in;
        this.length = length;
    }

    public BlobWrapper(String data) {
        StringInputStream sis;
        if (data == null) {
            throw new NullPointerException("Data cannot be null");
        }
        try {
            sis = new StringInputStream(data);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.in = sis;
        this.length = sis.getLength();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public long getLength() {
        return this.length;
    }
}

