/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTracer {
    private static final Logger log = LoggerFactory.getLogger(SqlTracer.class);
    private static final int REPORT_LIMIT = 100;
    private ConcurrentHashMap<String, AtomicLong> queries = new ConcurrentHashMap();
    private final AtomicLong selectQueriesCounter = new AtomicLong();
    private final AtomicLong updateQueriesCounter = new AtomicLong();
    private transient boolean enabled;
    private long traceStartTime;
    private long traceEndTime;

    public SqlTracer() {
        this(false);
    }

    SqlTracer(boolean enabled) {
        if (enabled) {
            this.traceStartTime = System.currentTimeMillis();
        }
        this.setEnabled(enabled);
    }

    private void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            this.traceStartTime = System.currentTimeMillis();
            this.traceEndTime = 0L;
        } else {
            this.traceEndTime = System.currentTimeMillis();
        }
        this.enabled = enabled;
    }

    public void traceSelectQuery(String query) {
        this.selectQueriesCounter.incrementAndGet();
        this.incrementQueryCount(query);
    }

    public void traceUpdateQuery(String query) {
        this.updateQueriesCounter.incrementAndGet();
        this.incrementQueryCount(query);
    }

    public long getSelectQueriesCount() {
        return this.selectQueriesCounter.get();
    }

    public long getUpdateQueriesCount() {
        return this.updateQueriesCounter.get();
    }

    public boolean isTracingEnabled() {
        return this.enabled;
    }

    public void enableTracing() {
        this.setEnabled(true);
    }

    public void disableTracing() {
        this.setEnabled(false);
    }

    public void resetTracing() {
        this.selectQueriesCounter.set(0L);
        this.updateQueriesCounter.set(0L);
        this.queries = new ConcurrentHashMap();
        this.traceEndTime = 0L;
        this.traceStartTime = this.enabled ? (this.traceStartTime = System.currentTimeMillis()) : 0L;
    }

    ConcurrentHashMap<String, AtomicLong> getQueries() {
        return this.queries;
    }

    public String report() {
        long reportTime = this.traceEndTime > 0L ? this.traceEndTime : System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        long selectCount = this.selectQueriesCounter.get();
        long updateCount = this.updateQueriesCounter.get();
        sb.append("SQL tracing report\n");
        sb.append("Enabled: ").append(this.enabled).append("\n");
        sb.append("Report time: ").append(sdf.format(reportTime)).append("\n").append("Period: ").append(sdf.format(this.traceStartTime)).append(" - ").append(sdf.format(reportTime)).append(" (").append(reportTime - this.traceStartTime).append(" ms)\n");
        sb.append("Total  queries: ").append(selectCount + updateCount).append("\n");
        sb.append("Select queries: ").append(selectCount).append("\n");
        sb.append("Update queries: ").append(updateCount).append("\n");
        sb.append("Top queries ordered by number of executions:\n");
        if (!this.enabled) {
            sb.append(" (tracing is currently disabled)");
        }
        this.queries.entrySet().stream().sorted(Map.Entry.comparingByValue((x, y) -> x.longValue() < y.longValue() ? -1 : (x.longValue() == y.longValue() ? 0 : 1)).reversed()).limit(100L).forEach(e -> sb.append(this.formatQueryEntry((Map.Entry<String, AtomicLong>)e)));
        String report = sb.toString();
        log.debug(report);
        return report;
    }

    private String formatQueryEntry(Map.Entry<String, AtomicLong> e) {
        return String.format("  %,8d %s%n", e.getValue().longValue(), e.getKey());
    }

    private void incrementQueryCount(String sql) {
        AtomicLong oldCount;
        if (!this.enabled) {
            return;
        }
        AtomicLong count = this.queries.get(sql);
        if (count == null && (oldCount = this.queries.putIfAbsent(sql, count = new AtomicLong(0L))) != null) {
            count = oldCount;
        }
        count.incrementAndGet();
    }
}

