/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util;

import org.jfrog.storage.util.TimeUnitFormat;

public class PerfTimer {
    private final long start = System.nanoTime();
    private long end;

    public long stop() {
        this.end = System.nanoTime();
        return this.end - this.start;
    }

    public long getTime() {
        if (this.end < this.start) {
            return -1L;
        }
        return this.end - this.start;
    }

    public String currentTimeString() {
        return this.getTimeString(System.nanoTime() - this.start);
    }

    public String getTimeString() {
        long nanos = this.getTime();
        return this.getTimeString(nanos);
    }

    public String toString() {
        return this.getTimeString();
    }

    private String getTimeString(long nanos) {
        return TimeUnitFormat.getTimeString(nanos);
    }
}

