/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.id;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.jfrog.storage.JFrogDataSource;
import org.jfrog.storage.StorageException;
import org.jfrog.storage.id.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIdGenerator
extends IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(SimpleIdGenerator.class);
    private final Object indexMonitor = new Object();
    private final AtomicLong currentIndex = new AtomicLong(0L);
    private volatile long maxReservedIndex = 0L;

    public SimpleIdGenerator(JFrogDataSource dataSource, long step, String tableName, String indexType) {
        super(dataSource, step, tableName, indexType);
    }

    @Override
    protected void initializeIndex(long currentValue) {
        this.maxReservedIndex = currentValue;
        if (currentValue != 0L) {
            ++currentValue;
        }
        this.currentIndex.set(currentValue);
        log.debug("Initialized current index to " + this.currentIndex.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId() {
        long value = this.currentIndex.getAndIncrement();
        if (this.isNotInRange(value)) {
            Object object = this.indexMonitor;
            synchronized (object) {
                value = this.getGoodValue(value);
            }
        }
        return value;
    }

    private long getGoodValue(long value) {
        if (this.isNotInRange(value)) {
            this.simpleUpdateIndex(value);
            if (value == 0L) {
                value = this.currentIndex.getAndIncrement();
            }
        }
        return value;
    }

    private boolean isNotInRange(long value) {
        return value > this.maxReservedIndex || value == 0L;
    }

    private void simpleUpdateIndex(long value) {
        log.trace("Starting updating index with current value={}", (Object)this.maxReservedIndex);
        try {
            long nextMaxCurrentIndex = Long.max(this.maxReservedIndex, value) + this.step();
            log.trace("Executing update index with value={}", (Object)nextMaxCurrentIndex);
            int rows = this.jdbcHelper().executeUpdate("UPDATE " + this.tableName() + " SET current_id = ? where index_type = ?", nextMaxCurrentIndex, this.indexType());
            if (rows != 1) {
                throw new StorageException("Failed to update the unique indices table, index type " + this.indexType() + " does not exists!");
            }
            this.maxReservedIndex = nextMaxCurrentIndex;
            log.trace("Updated index with value={}", (Object)this.maxReservedIndex);
        }
        catch (SQLException e) {
            throw new StorageException("Failed to update the unique indices table", e);
        }
    }
}

