/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.id;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.jfrog.storage.DatabaseHelper;
import org.jfrog.storage.JFrogDataSource;
import org.jfrog.storage.StorageException;
import org.jfrog.storage.id.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeBasedIdGenerator
extends IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(RangeBasedIdGenerator.class);
    private final int maxUpdateRetries;
    private final Object rangeSync = new Object();
    private volatile IndexRange currentRange = null;

    public RangeBasedIdGenerator(JFrogDataSource dataSource, long step, String tableName, String indexType, int maxUpdateRetries) {
        super(dataSource, step, tableName, indexType);
        this.maxUpdateRetries = maxUpdateRetries;
    }

    public RangeBasedIdGenerator(DatabaseHelper databaseHelper, long step, String tableName, String indexType, int maxUpdateRetries) {
        super(databaseHelper, step, tableName, indexType);
        this.maxUpdateRetries = maxUpdateRetries;
    }

    @Override
    protected void initializeIndex(long currentValue) {
        this.currentRange = new IndexRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId() {
        long value = this.currentRange.next();
        if (value == 0L) {
            Object object = this.rangeSync;
            synchronized (object) {
                value = this.currentRange.next();
                if (value == 0L) {
                    this.currentRange = this.getNextRange();
                    value = this.currentRange.next();
                }
            }
        }
        return value;
    }

    private IndexRange getNextRange() {
        long maxReservedIdFromDb = this.currentRange.max;
        log.trace("Starting loop of updating with current max={} and {} retries", (Object)maxReservedIdFromDb, (Object)this.maxUpdateRetries);
        for (int i = 0; i < this.maxUpdateRetries; ++i) {
            try {
                log.trace("#{} Creating select and update statements", (Object)i);
                long nextMaxCurrentIndex = maxReservedIdFromDb + this.step();
                log.trace("#{} executing update to next max={} from={}", new Object[]{i, nextMaxCurrentIndex, maxReservedIdFromDb});
                int rows = this.jdbcHelper().executeUpdate("UPDATE " + this.tableName() + " SET current_id = ? where index_type = ? AND current_id = ?", nextMaxCurrentIndex, this.indexType(), maxReservedIdFromDb);
                if (rows == 1) {
                    if (i > 10) {
                        log.info("#{} success updating index {} with range {}-{}", new Object[]{i + 1, this.indexType(), maxReservedIdFromDb, nextMaxCurrentIndex});
                    }
                    log.debug("#{} success updating index {} with range {}-{}", new Object[]{i + 1, this.indexType(), maxReservedIdFromDb, nextMaxCurrentIndex});
                    return new IndexRange(nextMaxCurrentIndex);
                }
                if (i > 10) {
                    log.info("#{} failed updating index {} with range {}-{}", new Object[]{i + 1, this.indexType(), maxReservedIdFromDb, nextMaxCurrentIndex});
                }
                if (i > 5) {
                    Thread.sleep(200L);
                }
                log.debug("#{} failed updating index {} with range {}-{}", new Object[]{i + 1, this.indexType(), maxReservedIdFromDb, nextMaxCurrentIndex});
                maxReservedIdFromDb = this.getMaxReservedIdFromDb();
                continue;
            }
            catch (SQLException e) {
                throw new StorageException("Failed to update the unique indices table", e);
            }
            catch (InterruptedException e) {
                throw new StorageException("Got interrupted while updating the unique indices table", e);
            }
        }
        throw new StorageException("Failed to update the unique indices table. Too many retries.");
    }

    private long getMaxReservedIdFromDb() throws SQLException {
        try (ResultSet rs = this.jdbcHelper().executeSelect("SELECT current_id FROM " + this.tableName() + " WHERE index_type = ?", this.indexType());){
            long l = rs.next() ? rs.getLong(1) : 0L;
            return l;
        }
    }

    class IndexRange {
        final long min;
        final long max;
        final AtomicLong current;

        IndexRange() {
            this.max = 0L;
            this.min = 0L;
            this.current = new AtomicLong(0L);
        }

        IndexRange(long max) {
            this.max = max;
            this.min = max - RangeBasedIdGenerator.this.step() + 1L;
            this.current = new AtomicLong(this.min);
        }

        long next() {
            long value = this.current.getAndIncrement();
            if (value > this.max) {
                return 0L;
            }
            return value;
        }
    }
}

