/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.id;

import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jfrog.storage.DatabaseHelper;
import org.jfrog.storage.JFrogDataSource;
import org.jfrog.storage.JdbcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    public static final long NO_ID = 0L;
    private final DatabaseHelper databaseHelper;
    private final long step;
    private final String tableName;
    private final String indexType;

    public IdGenerator(JFrogDataSource dataSource, long step, String tableName, String indexType) {
        this(new JdbcHelper(Objects.requireNonNull(dataSource, "data source is required")), step, tableName, indexType);
    }

    public IdGenerator(DatabaseHelper databaseHelper, long step, String tableName, String indexType) {
        this.databaseHelper = Objects.requireNonNull(databaseHelper, "database helper is required");
        this.step = IdGenerator.requirePositive(step, "step must be positive");
        this.tableName = IdGenerator.requireNonBlank(tableName, "table name is required");
        this.indexType = IdGenerator.requireNonBlank(indexType, "index type is required");
    }

    public long step() {
        return this.step;
    }

    @Nonnull
    public String tableName() {
        return this.tableName;
    }

    @Nonnull
    public String indexType() {
        return this.indexType;
    }

    @Nonnull
    protected DatabaseHelper jdbcHelper() {
        return this.databaseHelper;
    }

    public void initialize() throws SQLException {
        log.debug("Initializing ID generator: tableName={}, indexName={}, step={}", new Object[]{this.tableName, this.indexType, this.step});
        try {
            long initialIndex = this.databaseHelper.executeSelectLong("SELECT current_id FROM " + this.tableName + " WHERE index_type = ?", this.indexType);
            if (initialIndex == -1L) {
                int rows = this.databaseHelper.executeUpdate("INSERT INTO " + this.tableName + " VALUES (?, ?)", this.indexType, 0L);
                if (rows == 1) {
                    log.debug("Created current unique id for the first time");
                }
                initialIndex = 0L;
            }
            log.debug("Initialize index to {}", (Object)initialIndex);
            this.initializeIndex(initialIndex);
        }
        catch (Exception e) {
            throw new SQLException("Could not select current index.", e);
        }
    }

    protected abstract void initializeIndex(long var1);

    public abstract long nextId();

    private static String requireNonBlank(String value, String message) {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(message + " (got: " + value + ")");
        }
        return value;
    }

    private static long requirePositive(long value, String message) {
        if (value <= 0L) {
            throw new IllegalArgumentException(message + " (got: " + value + ")");
        }
        return value;
    }
}

