/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.dbtype;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jfrog.storage.dbtype.DefaultDbTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSpecificHelper
extends DefaultDbTypeHelper {
    private static final Logger log = LoggerFactory.getLogger(OracleSpecificHelper.class);
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String VALUES = " VALUES";

    @Override
    public String getInsertMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues) {
        return "INSERT ALL " + IntStream.range(0, numberOfValues).mapToObj(i -> " INTO " + tableAndFields + " VALUES " + valuesSql).collect(Collectors.joining(" ", "", " SELECT * FROM dual"));
    }

    @Override
    public void executeUpdateQuery(String query, Statement statement) throws SQLException {
        boolean insertIntoQuery;
        boolean bl = insertIntoQuery = query.startsWith(INSERT_INTO) && query.contains(VALUES);
        if (insertIntoQuery) {
            for (String sql : this.transformInsertIntoSeparateQueries(query)) {
                log.debug("add batch query: {}", (Object)sql);
                statement.addBatch(sql);
            }
            statement.executeBatch();
        } else {
            super.executeUpdateQuery(query, statement);
        }
    }

    private List<String> transformInsertIntoSeparateQueries(String query) {
        int values = query.indexOf(VALUES);
        if (values == -1) {
            throw new IllegalArgumentException("Query " + query + " does not contains the keyword  VALUES");
        }
        String baseString = query.substring(0, values + VALUES.length());
        String restOfString = query.substring(baseString.length() + 1);
        String[] rows = restOfString.split(",\n");
        List<String> result = Arrays.stream(rows).map(row -> baseString + " " + row).collect(Collectors.toList());
        log.info("Convert INSERT INTO in oracle found {} rows ", (Object)result.size());
        return result;
    }
}

