/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jfrog.common.ArgUtils;
import org.jfrog.common.ThrowingFunction;
import org.jfrog.storage.DbType;
import org.jfrog.storage.JdbcHelper;

public class SqlDaoHelper<V> {
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String WHERE = " WHERE ";
    private static final String SET = " SET ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String EQUALS_PARAM = " = ? ";
    private final JdbcHelper jdbcHelper;
    private final String tableName;
    private final DbType dbType;
    private final ThrowingFunction<ResultSet, V, SQLException> readValue;
    private final int batchSize;

    public SqlDaoHelper(JdbcHelper jdbcHelper, DbType dbType, String tableName, ThrowingFunction<ResultSet, V, SQLException> readValue, int batchSize) {
        this.dbType = dbType;
        this.jdbcHelper = Objects.requireNonNull(jdbcHelper, "jdbc helper is required");
        this.tableName = ArgUtils.requireNonBlank((String)tableName, (String)"table name is required");
        this.readValue = Objects.requireNonNull(readValue, "readValue function is required");
        this.batchSize = ArgUtils.requirePositive((Integer)batchSize, (String)"readValue function is required");
    }

    @Nonnull
    public List<V> getAll() throws SQLException {
        return this.findAllByQuery(SELECT_FROM + this.tableName, new Object[0]);
    }

    @Nonnull
    public Optional<V> findFirstByProperty(@Nonnull String property, @Nonnull Object value) throws SQLException {
        return this.findFirstValueByProperty(this.readValue, property, value);
    }

    @Nonnull
    public Optional<V> findFirstByProperties(@Nonnull List<String> fields, Object ... values) throws SQLException {
        return this.findFirstValueByProperties(this.readValue, fields, values);
    }

    @NotNull
    public Optional<V> findFirstValueByProperties(ThrowingFunction<ResultSet, V, SQLException> readValue, @Nonnull List<String> fields, Object ... values) throws SQLException {
        if (fields.size() != values.length) {
            throw new IllegalStateException("number of fields (" + fields.size() + ") didn't match number of values (" + values.length + ")");
        }
        String query = fields.stream().map(key -> key + " =?").collect(Collectors.joining(" AND ", SELECT_FROM + this.tableName + WHERE, ""));
        return this.findFirstValueByQuery(readValue, query, values);
    }

    @Nonnull
    public Optional<V> findFirstByQuery(@Nonnull String query, Object ... params) throws SQLException {
        return this.findFirstValueByQuery(this.readValue, query, params);
    }

    @Nonnull
    public <T> Optional<T> findFirstValueByProperty(@Nonnull ThrowingFunction<ResultSet, T, SQLException> valueReader, @Nonnull String property, @Nonnull Object value) throws SQLException {
        String query = SELECT_FROM + this.tableName + WHERE + property + " = ?";
        return this.findFirstValueByQuery(valueReader, query, value);
    }

    @Nonnull
    public <T> Optional<T> findFirstValueByQuery(@Nonnull ThrowingFunction<ResultSet, T, SQLException> valueReader, @Nonnull String query, Object ... params) throws SQLException {
        Object value = null;
        try (ResultSet resultSet = this.jdbcHelper.executeSelect(query, params);){
            if (resultSet.next()) {
                value = valueReader.apply((Object)resultSet);
            }
        }
        return Optional.ofNullable(value);
    }

    @Nonnull
    public <K, T> Map<K, T> findValuesByProperties(@Nonnull ThrowingFunction<ResultSet, K, SQLException> keyReader, @Nonnull ThrowingFunction<ResultSet, T, SQLException> valueReader, @Nonnull String property, @Nonnull List<K> values) throws SQLException {
        HashMap result = new HashMap();
        if (values.isEmpty()) {
            return result;
        }
        ThrowingFunction resultCollector = resultSet -> result.put(keyReader.apply(resultSet), valueReader.apply(resultSet));
        this.findByFieldWithPagination("*", this.tableName + WHERE + property, values, resultCollector);
        return result;
    }

    public int create(List<String> fields, Object ... values) throws SQLException {
        if (fields.size() != values.length) {
            throw new IllegalStateException("number of fields (" + fields.size() + ") didn't match number of values (" + values.length + ")");
        }
        String fieldsToSet = "(" + String.join((CharSequence)",", fields) + ")";
        return this.jdbcHelper.executeUpdate("INSERT INTO " + this.tableName + " " + fieldsToSet + " VALUES " + this.buildValuesString(values.length), values);
    }

    public <T> int paginationCreate(String tableNameAndFields, int numberOfFields, Function<T, Stream<Object>> groupToValues, T[] values) throws SQLException {
        String valuesString = this.buildValuesString(numberOfFields);
        Function<Integer, String> sqlBuilder = subListSize -> this.jdbcHelper.getDbSpecificHelper(this.dbType).getInsertMultipleValuesSql(tableNameAndFields, valuesString, (int)subListSize);
        return this.updatePagination(groupToValues, sqlBuilder, Function.identity(), values);
    }

    public <T> int paginationDelete(String tableNameAndFields, int numberOfFields, Function<T, Stream<Object>> groupToValues, Function<Object[], Object[]> paramsDecorator, T[] values) throws SQLException {
        String valuesString = this.buildValuesString(numberOfFields);
        Function<Integer, String> sqlBuilder = subListSize -> this.jdbcHelper.getDbSpecificHelper(this.dbType).getDeleteMultipleValuesSql(tableNameAndFields, valuesString, (int)subListSize);
        return this.updatePagination(groupToValues, sqlBuilder, paramsDecorator, values);
    }

    private <T> int paginationDeleteMultiColumnCondition(String tableNameAndOtherConditions, List<String> conditionColumns, Function<T, Stream<Object>> groupToValues, Function<Object[], Object[]> paramsDecorator, T[] values) throws SQLException {
        Function<Integer, String> sqlBuilder = subListSize -> this.jdbcHelper.getDbSpecificHelper(this.dbType).getDeleteMultipleColumnsMultipleValuesSql(tableNameAndOtherConditions, conditionColumns, (int)subListSize);
        return this.updatePagination(groupToValues, sqlBuilder, paramsDecorator, values);
    }

    private <T> int updatePagination(Function<T, Stream<Object>> groupToValues, Function<Integer, String> sqlBuilder, Function<Object[], Object[]> paramsDecorator, T[] values) throws SQLException {
        List<T> subList;
        List<T> fullList = Arrays.asList(values);
        if (fullList.isEmpty()) {
            return 0;
        }
        int res = 0;
        int passed = 0;
        int toIndex = Math.min(this.batchSize + passed, fullList.size());
        while (passed <= toIndex && !(subList = fullList.subList(passed, toIndex)).isEmpty()) {
            String query = sqlBuilder.apply(subList.size());
            Object[] params = subList.stream().flatMap(groupToValues).toArray(Object[]::new);
            params = paramsDecorator.apply(params);
            res += this.jdbcHelper.executeUpdate(query, params);
            toIndex = Math.min(this.batchSize + (passed += subList.size()), fullList.size());
        }
        return res;
    }

    private String buildValuesString(int numberOfFields) {
        return numberOfFields == 1 ? "? " : "(" + StringUtils.repeat((String)"?", (String)",", (int)numberOfFields) + ")";
    }

    public <T> List<V> findByFieldWithPagination(@Nonnull String returnValues, @Nonnull String tableNameAndField, Set<T> fieldValues) throws SQLException {
        ArrayList result = new ArrayList();
        ThrowingFunction resultCollector = resultSet -> result.add(this.readValue.apply(resultSet));
        this.findByFieldWithPagination(returnValues, tableNameAndField, fieldValues, resultCollector);
        return Collections.unmodifiableList(result);
    }

    public <T> List<V> findByMultiColumnQueryWithPagination(@Nonnull String returnValues, @Nonnull String tableNameAndFields, @Nonnull List<String> columns, Collection<T> params) throws SQLException {
        ArrayList result = new ArrayList();
        ThrowingFunction resultCollector = resultSet -> result.add(this.readValue.apply(resultSet));
        Function<Integer, String> queryBuilder = i -> this.jdbcHelper.getDbSpecificHelper(this.dbType).getQueryMultipleColumnsMultipleValuesSql(returnValues, tableNameAndFields, columns, (int)i);
        this.batchApply(params, resultCollector, queryBuilder, this.batchSize - this.batchSize % columns.size());
        return Collections.unmodifiableList(result);
    }

    private <T, V> void findByFieldWithPagination(@Nonnull String returnValues, @Nonnull String tableNameAndFields, Collection<T> params, ThrowingFunction<ResultSet, V, SQLException> resultsCollector) throws SQLException {
        Function<Integer, String> queryBuilder = i -> this.jdbcHelper.getDbSpecificHelper(this.dbType).getQueryMultipleValuesSql(returnValues, tableNameAndFields, "?", (int)i);
        this.batchApply(params, resultsCollector, queryBuilder, this.batchSize);
    }

    private <T, V> void batchApply(Collection<T> params, ThrowingFunction<ResultSet, V, SQLException> resultsCollector, Function<Integer, String> queryBuilder, int batchSize) throws SQLException {
        List subList;
        ArrayList<T> fullList = new ArrayList<T>(params);
        if (fullList.isEmpty()) {
            return;
        }
        int passed = 0;
        int toIndex = Math.min(batchSize + passed, fullList.size());
        while (passed <= toIndex && !(subList = fullList.subList(passed, toIndex)).isEmpty()) {
            Object[] currentParams = subList.toArray();
            String query = queryBuilder.apply(subList.size());
            try (ResultSet resultSet = this.jdbcHelper.executeSelect(query, currentParams);){
                while (resultSet.next()) {
                    resultsCollector.apply((Object)resultSet);
                }
            }
            toIndex = Math.min(batchSize + (passed += subList.size()), fullList.size());
        }
    }

    @Nonnull
    public List<V> findAllByProperty(@Nonnull String property, Object value) throws SQLException {
        String query = SELECT_FROM + this.tableName + WHERE + property + " = ?";
        return this.findAllByQuery(query, value);
    }

    @Nonnull
    public List<V> findAllByQuery(@Nonnull String query, Object ... params) throws SQLException {
        return this.findAllByQuery(query, this.readValue, params);
    }

    @Nonnull
    public <T> List<T> findAllByQuery(@Nonnull String query, ThrowingFunction<ResultSet, T, SQLException> converter, Object ... params) throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        try (ResultSet resultSet = this.jdbcHelper.executeSelect(query, params);){
            while (resultSet.next()) {
                Object entity = converter.apply((Object)resultSet);
                result.add(entity);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public int deleteAll() throws SQLException {
        return this.jdbcHelper.executeUpdate(DELETE_FROM + this.tableName, new Object[0]);
    }

    public int executeUpdate(String query, Object ... params) throws SQLException {
        return this.jdbcHelper.executeUpdate(query, params);
    }

    public int executeCount(String query, Object ... params) throws SQLException {
        return this.jdbcHelper.executeSelectCount(query, params);
    }

    public int deleteByProperty(String property, Object value) throws SQLException {
        return this.jdbcHelper.executeUpdate(DELETE_FROM + this.tableName + WHERE + property + " = ?", value);
    }

    public int deleteByProperties(List<Pair<String, Object>> properties) throws SQLException {
        return this.jdbcHelper.executeUpdate(DELETE_FROM + this.tableName + WHERE + properties.stream().map(pair -> (String)pair.getLeft() + " = ?").collect(Collectors.joining(" AND ")), properties.stream().map(Pair::getRight).toArray());
    }

    public int updateByProperty(Pair<String, Object> findBy, Pair<String, Object> toUpdate) throws SQLException {
        return this.jdbcHelper.executeUpdate("UPDATE " + this.tableName + SET + (String)toUpdate.getLeft() + " = ? WHERE " + (String)findBy.getLeft() + " = ?", toUpdate.getRight(), findBy.getRight());
    }

    public int updateByProperties(List<String> fieldsToFindBy, Stream<Object> valuesToFindBy, List<String> fieldsToUpdate, Stream<Object> updateValues) throws SQLException {
        Object[] params = Stream.concat(updateValues, valuesToFindBy).toArray();
        int numberOfFields = fieldsToUpdate.size() + fieldsToFindBy.size();
        if (numberOfFields != params.length) {
            throw new IllegalStateException("number of fields (" + numberOfFields + ") didn't match number of values (" + params.length + ")");
        }
        return this.jdbcHelper.executeUpdate("UPDATE " + this.tableName + this.buildSetClause(fieldsToUpdate) + this.buildWhereClause(fieldsToFindBy), params);
    }

    private String buildWhereClause(List<String> columns) {
        return columns.stream().collect(Collectors.joining(" = ?  AND ", " WHERE  ( ", " = ?  ) "));
    }

    private String buildSetClause(List<String> columns) {
        return columns.stream().collect(Collectors.joining(" = ?  , ", SET, EQUALS_PARAM));
    }

    public static Function<Object[], Object[]> buildDecorator(long userId) {
        return params -> {
            if (((Object[])params).length == 0) {
                return params;
            }
            Object[] result = new Object[((Object[])params).length + 1];
            result[0] = userId;
            System.arraycopy(params, 0, result, 1, ((Object[])params).length);
            return result;
        };
    }
}

