/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

public class QueryControls {
    static final QueryControls DEFAULT_QUERY_CONTROLS = new Builder().build();
    private final boolean allowDirtyReads;
    private final int queryTimeout;
    private final int networkTimeout;

    private QueryControls(boolean allowDirtyReads, int queryTimeout, int networkTimeout) {
        this.allowDirtyReads = allowDirtyReads;
        this.queryTimeout = queryTimeout;
        this.networkTimeout = networkTimeout;
    }

    public boolean isAllowDirtyReads() {
        return this.allowDirtyReads;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public static class Builder {
        private boolean allowDirtyReads;
        private int queryTimeout;
        private int networkTimeout;

        public QueryControls build() {
            return new QueryControls(this.allowDirtyReads, this.queryTimeout, this.networkTimeout);
        }

        public Builder allowDirtyReads() {
            this.allowDirtyReads = true;
            return this;
        }

        public Builder queryTimeout(int queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder networkTimeout(int networkTimeout) {
            this.networkTimeout = networkTimeout;
            return this;
        }
    }
}

