/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.IsolationLevel;
import java.util.concurrent.TimeUnit;
import org.jfrog.storage.DbProperties;
import org.jfrog.storage.JFrogDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariJDBCDataSource
extends HikariDataSource
implements JFrogDataSource {
    private static final Logger log = LoggerFactory.getLogger(HikariJDBCDataSource.class);

    public HikariJDBCDataSource(DbProperties p) {
        log.debug("Initializing Hikari pooling data source");
        this.setPoolName("HikariCP Main");
        this.setJdbcUrl(p.getConnectionUrl());
        this.setDriverClassName(p.getDriverClass());
        this.setUsername(p.getUsername());
        this.setPassword(p.getPassword());
        this.setCatalog(p.getProperty("defaultCatalog", null));
        this.setSchema(p.getProperty("schema", null));
        this.setAutoCommit(p.getBooleanProperty("defaultAutoCommit", true));
        this.setTransactionIsolation(IsolationLevel.TRANSACTION_READ_COMMITTED.name());
        this.setMaximumPoolSize(p.getMaxActiveConnections());
        this.setMaxLifetime(p.getIntProperty("maxAge", 1800000));
        this.setMinimumIdle(p.getIntProperty("minIdle", 1));
        this.setIdleTimeout(p.getIntProperty("minEvictableIdleTimeMillis", 300000));
        this.setConnectionTimeout(p.getIntProperty("maxWait", (int)TimeUnit.SECONDS.toMillis(120L)));
        this.setConnectionInitSql(p.getProperty("initSQL", null));
        this.setConnectionTestQuery(p.getProperty("validationQuery", null));
        this.setValidationTimeout(p.getIntProperty("validationQueryTimeout", 5000));
        this.setLeakDetectionThreshold(p.getLongProperty("leakDetectionThreshold", 0L));
        this.setAllowPoolSuspension(p.getBooleanProperty("allowPoolSuspension", false));
        this.setInitializationFailTimeout(p.getLongProperty("initializationFailTimeout", 1L));
        this.setIsolateInternalQueries(p.getBooleanProperty("isolateInternalQueries", false));
    }

    public static JFrogDataSource createUniqueIdDataSource(DbProperties p) {
        HikariJDBCDataSource ds = new HikariJDBCDataSource(p);
        ds.setPoolName("HikariCP Unique");
        ds.setAutoCommit(true);
        ds.setMaximumPoolSize(1);
        ds.setMinimumIdle(p.getIntProperty("minIdle", 0));
        ds.setLeakDetectionThreshold(p.getLongProperty("leakDetectionThreshold", 60000L));
        return ds;
    }
}

