/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.jfrog.sysconf.SysConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.jfrog.storage.DbType;

public abstract class DbProperties {
    public static final String DERBY_DB_HOME_PLACE_HOLDER = "{db.home}";
    public static final String TOMCAT_POOL_TYPE = "tomcat-jdbc";
    public static final String HIKARI_POOL_TYPE = "hikari";
    public static final String DEFAULT_POOL_TYPE = "hikari";
    protected final Map<String, String> props;
    protected final DbType dbType;
    private final SysConfig sysConfig;

    public DbProperties(SysConfig sysConfig, String defaultDbHome, String defaultDbLog) {
        this.sysConfig = sysConfig;
        this.props = Maps.newHashMap();
        try {
            this.dbType = this.resolveDbType(sysConfig);
            this.populateDbProperties(this.props, sysConfig);
            this.trimValues();
            this.assertMandatoryProperties(this.getMandatoryProperties());
            this.populateDerbyPropsIfNeeded(sysConfig, defaultDbHome, defaultDbLog);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to init db properties: ", e);
        }
    }

    private void populateDerbyPropsIfNeeded(SysConfig config, String defaultDbHome, String defaultDbLog) {
        if (this.dbType == DbType.DERBY) {
            System.setProperty("derby.stream.error.file", new File(defaultDbLog).getAbsolutePath());
            String dbHome = config.get(this.dbHomePropertyYamlKey(), defaultDbHome);
            this.props.put(this.dbHomePropertyYamlKey(), dbHome);
            String url = this.props.get(Key.URL.key()).replace(DERBY_DB_HOME_PLACE_HOLDER, dbHome);
            this.props.put(Key.URL.key(), url);
        }
    }

    private void populateDbProperties(Map<String, String> props, SysConfig config) {
        Stream.of(Key.values()).filter(rec$ -> ((Key)((Object)((Object)rec$))).hasDefaultValue()).forEach(prop -> props.put(prop.key(), config.get(this.yamlKey((Key)((Object)prop)), prop.getDefaultValue())));
        Stream.of(Key.values()).filter(prop -> config.get(this.yamlKey((Key)((Object)prop))).isPresent()).forEach(prop -> props.put(prop.key(), config.getOrFail(this.yamlKey((Key)((Object)prop)))));
    }

    public String getUsername() {
        return this.props.get(Key.USERNAME.key());
    }

    public String getConnectionUrl() {
        return this.props.get(Key.URL.key());
    }

    public String getPassword() {
        return this.props.get(Key.PASSWORD.key());
    }

    public String getDriverClass() {
        return this.props.get(Key.DRIVER.key());
    }

    public int getMaxActiveConnections() {
        return this.getIntProperty(Key.MAX_ACTIVE_CONNECTIONS.key(), this.getDefaultMaxActiveConnections());
    }

    public int getMaxIdleConnections() {
        return this.getIntProperty(Key.MAX_IDLE_CONNECTIONS.key(), this.getDefaultMaxIdleConnections());
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getPoolType() {
        return this.getProperty(Key.POOL_TYPE);
    }

    public String getProperty(Key property) {
        return this.props.get(property.key());
    }

    public String getProperty(Key key, String defaultValue) {
        return this.props.getOrDefault(key.key(), defaultValue);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getProperty(String key) {
        String value = this.props.get(key);
        if (value == null) {
            value = this.sysConfig.get(this.yamlKey(key), null);
        }
        return value;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(key, "" + defaultValue));
    }

    public int getIntProperty(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, "" + defaultValue));
    }

    public long getLongProperty(String key, long defaultValue) {
        return Long.parseLong(this.getProperty(key, "" + defaultValue));
    }

    private DbType resolveDbType(SysConfig config) {
        return DbType.parse(config.get(this.dbTypeYamlKey(), "derby"));
    }

    protected abstract int getDefaultMaxActiveConnections();

    protected abstract int getDefaultMaxIdleConnections();

    private String dbTypeYamlKey() {
        return this.yamlKey(Key.TYPE);
    }

    private String dbHomePropertyYamlKey() {
        return this.yamlKey(Key.DB_HOME);
    }

    private List<String> getMandatoryProperties() {
        return ImmutableList.of((Object)Key.TYPE.key(), (Object)Key.URL.key(), (Object)Key.DRIVER.key());
    }

    protected void assertMandatoryProperties(List<String> mandatoryProps) {
        for (String mandatoryProperty : mandatoryProps) {
            String value = this.getProperty(mandatoryProperty);
            if (!StringUtils.isBlank((String)value)) continue;
            throw new IllegalStateException("Mandatory database parameter '" + mandatoryProperty + "' doesn't exist");
        }
    }

    private void trimValues() {
        for (Map.Entry<String, String> entry : this.props.entrySet()) {
            String value = entry.getValue();
            if (StringUtils.trimToEmpty((String)value).equals(value)) continue;
            entry.setValue(StringUtils.trim((String)value));
        }
    }

    private String yamlKey(Key propKey) {
        return this.yamlKey(propKey.key());
    }

    String yamlKey(String propKey) {
        return this.getServicePrefix() + "database." + propKey;
    }

    protected abstract String getServicePrefix();

    public static enum Key {
        DB_HOME("dbHome"),
        USERNAME("username"),
        PASSWORD("password"),
        TYPE("type", "derby"),
        URL("url", "jdbc:derby:{db.home};create=true"),
        DRIVER("driver", "org.apache.derby.jdbc.EmbeddedDriver"),
        MAX_ACTIVE_CONNECTIONS("maxOpenConnections"),
        MAX_IDLE_CONNECTIONS("maxIdleConnections"),
        POOL_TYPE("poolType", "hikari"),
        POOL_MAX_ACTIVE("maxOpenConnections"),
        POOL_MAX_IDLE("maxIdleConnections"),
        LOCKING_DB_USERNAME("lockingdb.username"),
        LOCKING_DB_PASSWORD("lockingdb.password"),
        LOCKING_DB_TYPE("lockingdb.type"),
        LOCKING_DB_URL("lockingdb.url"),
        LOCKING_DB_DRIVER("lockingdb.driver"),
        LOCKING_DB_CATALOG("lockingdb.defaultCatalog");

        private final String propKey;
        private final String defaultValue;

        private Key(String propKey) {
            this.propKey = propKey;
            this.defaultValue = "";
        }

        private Key(String propKey, String defaultValue) {
            this.propKey = propKey;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.propKey;
        }

        private String getDefaultValue() {
            return this.defaultValue;
        }

        private boolean hasDefaultValue() {
            return StringUtils.isNotBlank((String)this.defaultValue);
        }
    }
}

