/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage;

import javax.annotation.Nonnull;
import org.jfrog.storage.DbProperties;
import org.jfrog.storage.HikariJDBCDataSource;
import org.jfrog.storage.JFrogDataSource;
import org.jfrog.storage.TomcatJDBCDataSource;
import org.jfrog.storage.wrapper.JFrogDataSourceWrapper;

public class DataSourceFactory {
    @Nonnull
    public JFrogDataSource createDataSource(DbProperties dbProps) {
        String poolType = dbProps.getPoolType();
        JFrogDataSource dataSource = poolType.equalsIgnoreCase("tomcat-jdbc") ? new TomcatJDBCDataSource(dbProps) : new HikariJDBCDataSource(dbProps);
        return JFrogDataSourceWrapper.newInstance(dataSource, dbProps);
    }

    @Nonnull
    public JFrogDataSource createUniqueIdsDataSource(DbProperties dbProps) {
        String poolType = dbProps.getPoolType();
        JFrogDataSource dataSource = poolType.equalsIgnoreCase("tomcat-jdbc") ? TomcatJDBCDataSource.createUniqueIdDataSource(dbProps) : HikariJDBCDataSource.createUniqueIdDataSource(dbProps);
        return JFrogDataSourceWrapper.newInstance(dataSource, dbProps);
    }
}

