/*
 *
 * Artifactory is a binaries repository manager.
 * Copyright (C) 2018 JFrog Ltd.
 *
 * Artifactory is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 * Artifactory is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Artifactory.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.jfrog.storage.util.querybuilder;

/**
 * @author Yinon Avraham
 */
public final class QueryBuilderUtils {

    private QueryBuilderUtils() {
    }

    public static long addButLimit(long positiveA, long positiveB, long positiveMax) {
        assert positiveA >= 0;
        assert positiveB >= 0;
        assert positiveMax >= 0;
        try {
            long result = Math.addExact(positiveA, positiveB);
            return result <= positiveMax ? result : positiveMax;
        } catch (ArithmeticException e) {
            return positiveMax;
        }
    }

}
