package org.jfrog.storage.priviledges;

import java.sql.Connection;


public class GenericDBPrivilegesVerifier implements DBPrivilegesVerifier {

    private static final String CREATE_TABLE1_STRING =
            "CREATE TABLE t1<suffix> (\n" +
                    "  ppkey             BIGINT, \n" +
                    "  CONSTRAINT t1id<suffix> PRIMARY KEY (ppkey)\n" +
                    ")";


    private static final String CREATE_TABLE2_STRING =
            "CREATE TABLE t2<suffix> (\n" +
                    "  id             BIGINT,\n" +
                    "  ffkey         BIGINT,\n" +
                    "  CONSTRAINT id<suffix> PRIMARY KEY (id),\n" +
                    "  CONSTRAINT t2_fk<suffix> FOREIGN KEY (ffkey) REFERENCES t1<suffix> (ppkey)\n" +
                    ");";


    @Override
    public boolean isSufficientPrivileges(Connection con, String caller) {
        return DbPrivilegesUtil.isSufficientPrivileges(con, caller, CREATE_TABLE1_STRING, CREATE_TABLE2_STRING);
    }
}
