package org.jfrog.storage.priviledges;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.Statement;

/**
 * @author Uriah Levy
 */
public class DbPrivilegesUtil {
    private static final String DROP_TABLE2_STRING = "DROP TABLE t2<suffix>";
    private static final String DROP_TABLE1_STRING = "DROP TABLE t1<suffix>";

    private static final Logger log = LoggerFactory.getLogger(DbPrivilegesUtil.class);

    public static boolean isSufficientPrivileges(Connection con, String caller, String createFirstTableSql,
                                                  String createSecondTableSql) {
        try (Statement stmt = con.createStatement()) {
            dropTableQuietly(caller, stmt, DROP_TABLE2_STRING);
            dropTableQuietly(caller, stmt, DROP_TABLE1_STRING);
            stmt.executeUpdate(createFirstTableSql.replaceAll("<suffix>", caller));
            stmt.executeUpdate(createSecondTableSql.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLE2_STRING.replaceAll("<suffix>", caller));
            stmt.executeUpdate(DROP_TABLE1_STRING.replaceAll("<suffix>", caller));
        } catch (Exception e) {
            log.error("Could not determine sufficient privileges", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    private static void dropTableQuietly(String caller, Statement stmt, String dropSql) {
        try {
            stmt.executeUpdate(dropSql.replaceAll("<suffix>", caller));
        } catch (Exception ignore) {
            // ignore
        }
    }
}
