package org.jfrog.storage.dbtype;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * @author Noam Shemesh
 */
public interface DbSpecificHelper {

    /**
     * A helper method to return the sql syntax just as in different databases
     */
    String getInsertMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues);

    String getDeleteMultipleValuesSql(String tableAndFields, String valuesSql, int numberOfValues);

    String getDeleteMultipleColumnsMultipleValuesSql(String tableAndOtherConditions, List<String> conditionColumns,
            int numberOfValues);

    String getQueryMultipleValuesSql(String returnedValues, String tableAndFields, String valuesSql,
            int numberOfValues);

    /**
     * Example: SELECT returnedValues FROM tableAndOtherFields (col1 = ? AND col2 = ?) OR (col1 = ? AND col2 = ?)
     */
    String getQueryMultipleColumnsMultipleValuesSql(String returnedValues, String tableAndOtherFields,
            List<String> columns, int numberOfValues);

    /**
     * internal usage only, execute queries should be run via JdbcHelper.executeUpdate
     */
    void executeUpdateQuery(String query, Statement statement) throws SQLException;
}