package org.jfrog.storage;

import org.jfrog.storage.wrapper.JFrogDataSourceWrapper;

import javax.annotation.Nonnull;

import static org.jfrog.storage.DbProperties.TOMCAT_POOL_TYPE;

/**
 * Factory to create data source based on the configured pool.
 *
 * @author Yossi Shaul
 */
public class DataSourceFactory {

    /**
     * @return JDBC DataSource based on the configured pool and db properties
     */
    @Nonnull
    public JFrogDataSource createDataSource(DbProperties dbProps) {
        String poolType = dbProps.getPoolType();
        JFrogDataSource dataSource = poolType.equalsIgnoreCase(TOMCAT_POOL_TYPE) ?
                new TomcatJDBCDataSource(dbProps) : new HikariJDBCDataSource(dbProps);
        return JFrogDataSourceWrapper.newInstance(dataSource, dbProps);
    }

    /**
     * @return JDBC DataSource based on the configured pool and db properties for unique IDs generation
     */
    @Nonnull
    public JFrogDataSource createUniqueIdsDataSource(DbProperties dbProps) {
        String poolType = dbProps.getPoolType();
        JFrogDataSource dataSource = poolType.equalsIgnoreCase(TOMCAT_POOL_TYPE) ?
                TomcatJDBCDataSource.createUniqueIdDataSource(dbProps) :
                HikariJDBCDataSource.createUniqueIdDataSource(dbProps);
        return JFrogDataSourceWrapper.newInstance(dataSource, dbProps);
    }
}
