/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util.querybuilder;

import org.apache.commons.lang.StringUtils;
import org.jfrog.storage.util.querybuilder.BaseQueryBuilder;
import org.jfrog.storage.util.querybuilder.QueryBuilderUtils;

public class SqlServerQueryBuilder
extends BaseQueryBuilder {
    @Override
    public String uniqueBuild(String baseQuery, String sortBy, long offSet, long limit) {
        StringBuilder builder = new StringBuilder();
        if (offSet > 0L || this.isForceAddOffset()) {
            return this.createQueryWithOffset(baseQuery, sortBy, offSet, limit, builder);
        }
        return this.createQueryWithoutOffset(baseQuery, sortBy, limit, builder);
    }

    public boolean isForceAddOffset() {
        return false;
    }

    private String createQueryWithOffset(String baseQuery, String sortBy, long offSet, long limit, StringBuilder builder) {
        long lng = QueryBuilderUtils.addButLimit(limit, ++offSet, Long.MAX_VALUE);
        builder.append("Select bb.* From (");
        builder.append("Select aa.* ");
        Object extraRowNumberField = " ,ROW_NUMBER() ";
        if (StringUtils.isBlank((String)sortBy)) {
            extraRowNumberField = (String)extraRowNumberField + "OVER ( order by (SELECT 1)) AS RN ";
        } else {
            String[] split = StringUtils.split((String)sortBy, (String)",");
            StringBuilder newSortBy = new StringBuilder();
            for (String s : split) {
                newSortBy.append("aa.").append(s.substring(s.indexOf(46) + 1)).append(",");
            }
            newSortBy = new StringBuilder(newSortBy.substring(0, newSortBy.length() - 1));
            extraRowNumberField = (String)extraRowNumberField + "OVER ( order by " + newSortBy + " ) AS RN ";
        }
        builder.append((String)extraRowNumberField);
        builder.append(" from ( ");
        builder.append(baseQuery).append(" ) aa");
        builder.append(" ) bb");
        builder.append(" Where bb.RN >= ").append(offSet);
        builder.append(" AND bb.RN < ").append(lng);
        builder.append(" ");
        return builder.toString();
    }

    private String createQueryWithoutOffset(String baseQuery, String sortBy, long limit, StringBuilder builder) {
        builder.append("Select top ");
        builder.append(limit);
        builder.append(" * From (");
        builder.append(baseQuery).append(" ) aa ");
        if (!StringUtils.isBlank((String)sortBy)) {
            builder.append("order by ");
            builder.append(sortBy);
        }
        return builder.toString();
    }

    @Override
    public boolean shouldAddOrderBy(Long offSet, Long limit) {
        return !this.isPagination(offSet, limit);
    }
}

