/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util.querybuilder;

import org.jfrog.storage.DbType;
import org.jfrog.storage.util.querybuilder.DerbyQueryBuilder;
import org.jfrog.storage.util.querybuilder.IQueryBuilder;
import org.jfrog.storage.util.querybuilder.MysqlQueryBuilder;
import org.jfrog.storage.util.querybuilder.OracleQueryBuilder;
import org.jfrog.storage.util.querybuilder.PostgresqlQueryBuilder;
import org.jfrog.storage.util.querybuilder.SqlServerQueryBuilder;

public class QueryWriter {
    private final IQueryBuilder queryBuilder;
    private String distinct;
    private String fields;
    private String tables;
    private JoinType joinType;
    private String joinTables;
    private String joinOn;
    private String conditions;
    private String groupBy;
    private String orderBy;
    private Long offSet;
    private Long limit;

    public QueryWriter(DbType dbType) {
        this.queryBuilder = this.getQueryBuilder(dbType);
    }

    public QueryWriter(IQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    private IQueryBuilder getQueryBuilder(DbType dbType) {
        switch (dbType) {
            case ORACLE: {
                return new OracleQueryBuilder();
            }
            case MSSQL: {
                return new SqlServerQueryBuilder();
            }
            case POSTGRESQL: {
                return new PostgresqlQueryBuilder();
            }
            case MYSQL: 
            case MARIADB: {
                return new MysqlQueryBuilder();
            }
        }
        return new DerbyQueryBuilder();
    }

    public QueryWriter distinct() {
        this.distinct = "distinct ";
        return this;
    }

    public QueryWriter select() {
        this.fields = " * ";
        return this;
    }

    public QueryWriter select(String fields) {
        this.fields = fields;
        return this;
    }

    public QueryWriter from(String tables) {
        this.tables = tables;
        return this;
    }

    public QueryWriter innerJoin(String joinTable, String joinOn) {
        this.joinType = JoinType.INNER;
        this.joinTables = joinTable;
        this.joinOn = joinOn;
        return this;
    }

    public QueryWriter leftJoin(String joinTable, String joinOn) {
        this.joinType = JoinType.LEFT;
        this.joinTables = joinTable;
        this.joinOn = joinOn;
        return this;
    }

    public QueryWriter groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public QueryWriter where(String condition) {
        this.conditions = condition;
        return this;
    }

    public QueryWriter orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public QueryWriter offset(Long offset) {
        this.offSet = offset;
        return this;
    }

    public QueryWriter limit(Long limit) {
        this.limit = limit;
        return this;
    }

    public String build() {
        return this.queryBuilder.build(this.distinct, this.fields, this.tables, this.joinType != null ? this.joinType.name() : null, this.joinTables, this.joinOn, this.conditions, this.orderBy, this.groupBy, this.offSet, this.limit);
    }

    public void clear() {
        this.distinct = null;
        this.fields = null;
        this.tables = null;
        this.joinType = null;
        this.joinTables = null;
        this.joinOn = null;
        this.conditions = null;
        this.groupBy = null;
        this.orderBy = null;
        this.offSet = null;
        this.limit = null;
    }

    public static enum JoinType {
        INNER("inner"),
        LEFT("left");

        final String joinType;

        private JoinType(String joinType) {
            this.joinType = joinType;
        }
    }
}

