/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util.querybuilder;

import org.apache.commons.lang.StringUtils;
import org.jfrog.storage.util.querybuilder.IQueryBuilder;

public abstract class BaseQueryBuilder
implements IQueryBuilder {
    @Override
    public String build(String distinct, String fields, String tables, String joinType, String joinTable, String joinOn, String conditions, String orderBy, String groupBy, Long offSet, Long limit) {
        String result;
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        if (!StringUtils.isBlank((String)distinct)) {
            builder.append("distinct ");
        }
        if (StringUtils.isBlank((String)fields)) {
            builder.append("* ");
        } else {
            builder.append(fields);
        }
        builder.append(" from ");
        if (StringUtils.isBlank((String)tables)) {
            throw new RuntimeException("Failed to build sql query. Reason: missing tables for the from section");
        }
        builder.append(tables);
        if (joinType != null && !StringUtils.isBlank((String)joinTable) && !StringUtils.isBlank((String)joinOn)) {
            builder.append(joinType).append(" join ");
            builder.append(joinTable);
            builder.append(" on ");
            builder.append(joinOn);
        }
        if (!StringUtils.isBlank((String)conditions)) {
            builder.append(" where ");
            builder.append(conditions);
        }
        if (!StringUtils.isBlank((String)groupBy)) {
            builder.append(" group by ");
            builder.append(groupBy);
        }
        if (this.shouldAddOrderBy(offSet, limit) && !StringUtils.isBlank((String)orderBy)) {
            builder.append(" order by ");
            builder.append(orderBy);
        }
        if (this.isPagination(offSet, limit)) {
            if (offSet == null || offSet < 0L) {
                offSet = 0L;
            }
            if (limit == null || limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            result = this.uniqueBuild(builder.toString(), orderBy, offSet, limit);
        } else {
            result = builder.toString();
        }
        return result;
    }

    protected abstract String uniqueBuild(String var1, String var2, long var3, long var5);

    public abstract boolean shouldAddOrderBy(Long var1, Long var2);

    boolean isPagination(Long offSet, Long limit) {
        return offSet != null && offSet > 0L || limit != null && limit < Long.MAX_VALUE;
    }
}

