/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.storage.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.storage.wrapper.BlobWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbStatementUtils {
    private static final Logger log = LoggerFactory.getLogger(DbStatementUtils.class);
    private static final String INSERT_INTO = "INSERT INTO ";
    public static final String VALUES = " VALUES";

    private DbStatementUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlStream(Connection con, InputStream in) throws IOException, SQLException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        Statement stmt = con.createStatement();
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((String)line) || line.startsWith("--") || line.startsWith("#")) continue;
                sb.append(line);
                if (line.endsWith(";")) {
                    String databaseProductName;
                    String query = sb.substring(0, sb.length() - 1);
                    if (query.startsWith(INSERT_INTO) && "Oracle".equals(databaseProductName = con.getMetaData().getDatabaseProductName())) {
                        query = DbStatementUtils.transformInsertIntoForOracle(query);
                    }
                    log.debug("Executing query:\n{}", (Object)query);
                    try {
                        stmt.executeUpdate(query);
                        if (!con.getAutoCommit()) {
                            con.commit();
                        }
                    }
                    catch (SQLException e) {
                        log.error("Failed to execute query: {}:\n{}", (Object)e.getMessage(), (Object)query);
                        throw e;
                    }
                    sb = new StringBuilder();
                    continue;
                }
                sb.append("\n");
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            DbStatementUtils.close(stmt);
        }
    }

    static String transformInsertIntoForOracle(String query) {
        int values = query.indexOf(VALUES);
        if (values == -1) {
            throw new IllegalArgumentException("Query " + query + " does not the keyword  VALUES");
        }
        String tableName = query.substring(INSERT_INTO.length(), values).trim();
        log.info("Doing insert all in Oracle for table " + tableName);
        StringBuilder sb = new StringBuilder("INSERT ALL ");
        boolean inValue = false;
        for (char c : query.toCharArray()) {
            if (c == '(') {
                inValue = true;
                sb.append("INTO ").append(tableName).append(VALUES).append(" (");
                continue;
            }
            if (c == ')') {
                inValue = false;
                sb.append(")\n");
                continue;
            }
            if (!inValue) continue;
            sb.append(c);
        }
        sb.append("SELECT * FROM dual");
        return sb.toString();
    }

    public static String parseInListQuery(String sql, Object ... params) {
        int idx = sql.indexOf("(#)");
        if (idx != -1) {
            ArrayList<Integer> iterableSizes = new ArrayList<Integer>(1);
            for (Object param : params) {
                int size;
                if (!(param instanceof Collection) || (size = ((Collection)param).size()) <= 0) continue;
                iterableSizes.add(size);
            }
            if (iterableSizes.isEmpty()) {
                throw new IllegalArgumentException("Could not find collection in parameters needed for query " + sql);
            }
            StringBuilder builder = new StringBuilder(sql.substring(0, idx + 1));
            for (int i = 0; i < (Integer)iterableSizes.get(0); ++i) {
                if (i != 0) {
                    builder.append(',');
                }
                builder.append('?');
            }
            builder.append(sql.substring(idx + 2));
            return builder.toString();
        }
        return sql;
    }

    public static void setParamsToStmt(PreparedStatement pstmt, Object[] params) throws SQLException {
        int i = 1;
        for (Object param : params) {
            if (param instanceof Iterable) {
                for (Object p : (Iterable)param) {
                    pstmt.setObject(i++, p);
                }
                continue;
            }
            if (param instanceof BlobWrapper) {
                BlobWrapper blobWrapper = (BlobWrapper)param;
                if (blobWrapper.getLength() < 0L) {
                    pstmt.setBinaryStream(i++, blobWrapper.getInputStream());
                    continue;
                }
                pstmt.setBinaryStream(i++, blobWrapper.getInputStream(), blobWrapper.getLength());
                continue;
            }
            pstmt.setObject(i++, param);
        }
    }

    public static void close(@Nullable Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.trace("Could not close JDBC statement", (Throwable)e);
            }
            catch (Exception e) {
                log.trace("Unexpected exception when closing JDBC statement", (Throwable)e);
            }
        }
    }
}

